/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.KeyedExtensionCollector;
import gnu.trove.THashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;

public class ClassExtension<T>
extends KeyedExtensionCollector<T, Class> {
    public ClassExtension(@NonNls String epName) {
        super(epName);
    }

    @Override
    protected String keyToString(Class key) {
        return key.getName();
    }

    @Override
    protected List<T> buildExtensions(String key, Class classKey) {
        THashSet allSupers = new THashSet();
        ClassExtension.collectSupers(classKey, (Set<String>)allSupers);
        return this.buildExtensions((Set<String>)allSupers);
    }

    private static void collectSupers(Class classKey, Set<String> allSupers) {
        Class<?>[] interfaces;
        allSupers.add(classKey.getName());
        for (Class<?> anInterface : interfaces = classKey.getInterfaces()) {
            ClassExtension.collectSupers(anInterface, allSupers);
        }
        Class superClass = classKey.getSuperclass();
        if (superClass != null) {
            ClassExtension.collectSupers(superClass, allSupers);
        }
    }

    public T forClass(Class t) {
        List ts = this.forKey(t);
        return ts.isEmpty() ? null : (T)ts.get(0);
    }
}

