/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;

public abstract class VcsTaskHandler {
    private static final ExtensionPointName<VcsTaskHandler> EXTENSION_POINT_NAME = ExtensionPointName.create((String)"com.intellij.vcs.taskHandler");

    public static VcsTaskHandler[] getAllHandlers(Project project) {
        Object[] extensions = (VcsTaskHandler[])EXTENSION_POINT_NAME.getExtensions((AreaInstance)project);
        List handlers = ContainerUtil.filter((Object[])extensions, (Condition)new Condition<VcsTaskHandler>(){

            public boolean value(VcsTaskHandler handler) {
                return handler.isEnabled();
            }
        });
        return handlers.toArray(new VcsTaskHandler[handlers.size()]);
    }

    public abstract boolean isEnabled();

    public abstract TaskInfo startNewTask(String var1);

    public abstract void switchToTask(TaskInfo var1, Runnable var2);

    public abstract void closeTask(TaskInfo var1, TaskInfo var2);

    public abstract boolean isSyncEnabled();

    public abstract TaskInfo[] getCurrentTasks();

    public abstract TaskInfo[] getAllExistingTasks();

    public static class TaskInfo {
        private final String myBranch;
        private final Collection<String> myRepositories;

        public TaskInfo(String branch, Collection<String> repositories) {
            this.myBranch = branch;
            this.myRepositories = repositories;
        }

        public String getName() {
            return this.myBranch;
        }

        public Collection<String> getRepositories() {
            return this.myRepositories;
        }

        public String toString() {
            return this.getName();
        }
    }
}

