/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.annotate;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.annotate.AnnotationSourceSwitcher;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspect;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Date;
import java.util.List;

public abstract class FileAnnotation {
    private final Project myProject;
    private Runnable myCloser;

    protected FileAnnotation(Project project) {
        this.myProject = project;
    }

    public abstract void dispose();

    public abstract LineAnnotationAspect[] getAspects();

    public abstract String getToolTip(int var1);

    public abstract String getAnnotatedContent();

    public abstract VcsRevisionNumber getLineRevisionNumber(int var1);

    public abstract Date getLineDate(int var1);

    public abstract VcsRevisionNumber originalRevision(int var1);

    public abstract VcsRevisionNumber getCurrentRevision();

    public abstract List<VcsFileRevision> getRevisions();

    public abstract boolean revisionsNotEmpty();

    public abstract AnnotationSourceSwitcher getAnnotationSourceSwitcher();

    public abstract int getLineCount();

    public final void close() {
        this.myCloser.run();
    }

    public void setCloser(Runnable closer) {
        this.myCloser = closer;
    }

    public VcsKey getVcsKey() {
        return null;
    }

    public boolean isBaseRevisionChanged(VcsRevisionNumber number) {
        VcsRevisionNumber currentRevision = this.getCurrentRevision();
        return currentRevision != null && !currentRevision.equals(number);
    }

    public abstract VirtualFile getFile();

    public void unregister() {
        ProjectLevelVcsManager.getInstance(this.myProject).getAnnotationLocalChangesListener().unregisterAnnotation(this.getFile(), this);
    }
}

