/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.BinaryContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;

public class CurrentBinaryContentRevision
extends CurrentContentRevision
implements BinaryContentRevision {
    public CurrentBinaryContentRevision(FilePath file) {
        super(file);
    }

    @Override
    public byte[] getBinaryContent() throws VcsException {
        VirtualFile vFile = this.getVirtualFile();
        if (vFile == null) {
            return null;
        }
        try {
            return vFile.contentsToByteArray();
        }
        catch (IOException e) {
            throw new VcsException(e);
        }
    }

    @Override
    @NonNls
    public String toString() {
        return "CurrentBinaryContentRevision:" + this.myFile;
    }
}

