/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentBinaryContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NonNls;

public class CurrentContentRevision
implements ContentRevision {
    protected FilePath myFile;

    public CurrentContentRevision(FilePath file) {
        this.myFile = file;
    }

    @Override
    public String getContent() {
        VirtualFile vFile = this.getVirtualFile();
        if (vFile == null) {
            this.myFile.refresh();
            vFile = this.getVirtualFile();
            if (vFile == null) {
                return null;
            }
        }
        final VirtualFile finalVFile = vFile;
        Document doc = ApplicationManager.getApplication().runReadAction(new Computable<Document>(){

            public Document compute() {
                return FileDocumentManager.getInstance().getDocument(finalVFile);
            }
        });
        if (doc == null) {
            return null;
        }
        return doc.getText();
    }

    public VirtualFile getVirtualFile() {
        VirtualFile vFile = this.myFile.getVirtualFile();
        if (vFile == null || !vFile.isValid()) {
            return null;
        }
        return vFile;
    }

    @Override
    public FilePath getFile() {
        return this.myFile;
    }

    @Override
    public VcsRevisionNumber getRevisionNumber() {
        return VcsRevisionNumber.NULL;
    }

    public static ContentRevision create(FilePath file) {
        if (file.getFileType().isBinary()) {
            return new CurrentBinaryContentRevision(file);
        }
        return new CurrentContentRevision(file);
    }

    @NonNls
    public String toString() {
        return "CurrentContentRevision:" + this.myFile;
    }
}

