/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.history.ShortVcsRevisionNumber;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;

public class TextRevisionNumber
implements ShortVcsRevisionNumber {
    private final String myFullRevisionNumber;
    private final String myShortRevisionNumber;

    public TextRevisionNumber(String fullRevisionNumber) {
        this(fullRevisionNumber, fullRevisionNumber.substring(0, Math.min(7, fullRevisionNumber.length())));
    }

    public TextRevisionNumber(String fullRevisionNumber, String shortRevisionNumber) {
        this.myFullRevisionNumber = fullRevisionNumber;
        this.myShortRevisionNumber = shortRevisionNumber;
    }

    @Override
    public String asString() {
        return this.myFullRevisionNumber;
    }

    @Override
    public int compareTo(VcsRevisionNumber o) {
        return Comparing.compare((Comparable)((Object)this.myFullRevisionNumber), (Comparable)((Object)((TextRevisionNumber)o).myFullRevisionNumber));
    }

    @Override
    public String toShortString() {
        return this.myShortRevisionNumber;
    }
}

