/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.contentAnnotation;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.contentAnnotation.ContentAnnotationCache;
import com.intellij.openapi.vcs.history.HistoryCacheWithRevisionKey;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.SLRUMap;
import java.util.Date;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class ContentAnnotationCacheImpl
implements ContentAnnotationCache {
    private final SLRUMap<HistoryCacheWithRevisionKey, TreeMap<Integer, Long>> myCache;
    private final Object myLock = new Object();

    public ContentAnnotationCacheImpl() {
        this.myCache = new SLRUMap(50, 50);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ThreeState isRecent(VirtualFile vf, VcsKey vcsKey, VcsRevisionNumber number, TextRange range, long boundTime) {
        TreeMap treeMap;
        Object object = this.myLock;
        synchronized (object) {
            treeMap = (TreeMap)this.myCache.get((Object)new HistoryCacheWithRevisionKey(VcsContextFactory.SERVICE.getInstance().createFilePathOn(vf), vcsKey, number));
        }
        if (treeMap != null) {
            Map.Entry last = treeMap.floorEntry(range.getEndOffset());
            if (last == null || last.getKey() < range.getStartOffset()) {
                return ThreeState.NO;
            }
            Map.Entry first = treeMap.ceilingEntry(range.getStartOffset());
            assert (first != null);
            SortedMap interval = treeMap.subMap(first.getKey(), last.getKey());
            for (Map.Entry entry : interval.entrySet()) {
                if ((Long)entry.getValue() < boundTime) continue;
                return ThreeState.YES;
            }
            return ThreeState.NO;
        }
        return ThreeState.UNSURE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(VirtualFile vf, VcsKey vcsKey, VcsRevisionNumber number, FileAnnotation fa) {
        HistoryCacheWithRevisionKey key = new HistoryCacheWithRevisionKey(VcsContextFactory.SERVICE.getInstance().createFilePathOn(vf), vcsKey, number);
        Object object = this.myLock;
        synchronized (object) {
            if (this.myCache.get((Object)key) != null) {
                return;
            }
        }
        long absoluteLimit = System.currentTimeMillis() - 2678400000L;
        TreeMap<Integer, Long> map = new TreeMap<Integer, Long>();
        int lineCount = fa.getLineCount();
        for (int i = 0; i < lineCount; ++i) {
            Date lineDate = fa.getLineDate(i);
            if (lineDate == null) {
                return;
            }
            if (lineDate.getTime() < absoluteLimit) continue;
            map.put(i, lineDate.getTime());
        }
        Object object2 = this.myLock;
        synchronized (object2) {
            this.myCache.put((Object)key, map);
        }
    }
}

