/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Throwable2Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.FilePathsHelper;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.CurrentRevisionProvider;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.encoding.EncodingRegistry;
import com.intellij.reference.SoftReference;
import com.intellij.util.Consumer;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.SLRUMap;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Set;

public class ContentRevisionCache {
    private final Object myLock = new Object();
    private final SLRUMap<Key, SoftReference<byte[]>> myCache = new SLRUMap(100, 50);
    private final SLRUMap<CurrentKey, VcsRevisionNumber> myCurrentRevisionsCache = new SLRUMap(200, 50);
    private final SLRUMap<Pair<FilePath, VcsRevisionNumber>, Object> myCustom = new SLRUMap(30, 30);
    private long myCounter = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void put(FilePath path, VcsRevisionNumber number, VcsKey vcsKey, UniqueType type, byte[] bytes) {
        if (bytes == null) {
            return;
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myCache.put((Object)new Key(path, number, vcsKey, type), (Object)new SoftReference((Object)bytes));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(FilePath path, VcsRevisionNumber number, VcsKey vcsKey, UniqueType type) {
        Object object = this.myLock;
        synchronized (object) {
            byte[] bytes = this.getBytes(path, number, vcsKey, type);
            if (bytes == null) {
                return null;
            }
            return ContentRevisionCache.bytesToString(path, bytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putCustom(FilePath path, VcsRevisionNumber number, Object o) {
        Object object = this.myLock;
        synchronized (object) {
            this.myCustom.put((Object)Pair.create((Object)path, (Object)number), o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getCustom(FilePath path, VcsRevisionNumber number) {
        Object object = this.myLock;
        synchronized (object) {
            return this.myCustom.get((Object)Pair.create((Object)path, (Object)number));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllCurrent() {
        Object object = this.myLock;
        synchronized (object) {
            ++this.myCounter;
            this.myCurrentRevisionsCache.clear();
        }
    }

    public void clearScope(final List<VcsDirtyScope> scopes) {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = ContentRevisionCache.this.myLock;
                synchronized (object) {
                    ++ContentRevisionCache.this.myCounter;
                    for (final VcsDirtyScope scope : scopes) {
                        HashSet toRemove = new HashSet();
                        ContentRevisionCache.this.myCurrentRevisionsCache.iterateKeys((Consumer)new Consumer<CurrentKey>((Set)toRemove){
                            final /* synthetic */ Set val$toRemove;
                            {
                                this.val$toRemove = set;
                            }

                            public void consume(CurrentKey currentKey) {
                                if (scope.belongsTo(currentKey.getPath())) {
                                    this.val$toRemove.add(currentKey);
                                }
                            }
                        });
                        for (CurrentKey key : toRemove) {
                            ContentRevisionCache.this.myCurrentRevisionsCache.remove((Object)key);
                        }
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCurrent(Set<String> paths) {
        final HashSet converted = new HashSet();
        for (String path : paths) {
            converted.add((Object)FilePathsHelper.convertPath(path));
        }
        Object object = this.myLock;
        synchronized (object) {
            HashSet toRemove = new HashSet();
            this.myCurrentRevisionsCache.iterateKeys((Consumer)new Consumer<CurrentKey>((Set)toRemove){
                final /* synthetic */ Set val$toRemove;
                {
                    this.val$toRemove = set;
                }

                public void consume(CurrentKey currentKey) {
                    if (converted.contains((Object)FilePathsHelper.convertPath(currentKey.getPath().getPath()))) {
                        this.val$toRemove.add(currentKey);
                    }
                }
            });
            for (CurrentKey key : toRemove) {
                this.myCurrentRevisionsCache.remove((Object)key);
            }
        }
    }

    public static String getOrLoadAsString(Project project, FilePath file, VcsRevisionNumber number, VcsKey key, UniqueType type, Throwable2Computable<byte[], VcsException, IOException> loader, Charset charset) throws VcsException, IOException {
        if (charset == null) {
            return ContentRevisionCache.getOrLoadAsString(project, file, number, key, type, loader);
        }
        byte[] bytes = ContentRevisionCache.getOrLoadAsBytes(project, file, number, key, type, loader);
        return CharsetToolkit.bytesToString((byte[])bytes, (Charset)charset);
    }

    private static String bytesToString(FilePath path, byte[] bytes) {
        Charset charset = null;
        if (path.getVirtualFile() != null) {
            charset = path.getVirtualFile().getCharset();
        }
        if (charset != null) {
            int bomLength = CharsetToolkit.getBOMLength((byte[])bytes, (Charset)charset);
            CharBuffer charBuffer = charset.decode(ByteBuffer.wrap(bytes, bomLength, bytes.length - bomLength));
            return charBuffer.toString();
        }
        return CharsetToolkit.bytesToString((byte[])bytes, (Charset)EncodingRegistry.getInstance().getDefaultCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(FilePath path, VcsRevisionNumber number, VcsKey vcsKey, UniqueType type) {
        Object object = this.myLock;
        synchronized (object) {
            SoftReference reference = (SoftReference)this.myCache.get((Object)new Key(path, number, vcsKey, type));
            return (byte[])SoftReference.dereference((Reference)reference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean putCurrent(FilePath path, VcsRevisionNumber number, VcsKey vcsKey, long counter) {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myCounter != counter) {
                return false;
            }
            ++this.myCounter;
            this.myCurrentRevisionsCache.put((Object)new CurrentKey(path, vcsKey), (Object)number);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<VcsRevisionNumber, Long> getCurrent(FilePath path, VcsKey vcsKey) {
        Object object = this.myLock;
        synchronized (object) {
            return new Pair(this.myCurrentRevisionsCache.get((Object)new CurrentKey(path, vcsKey)), (Object)this.myCounter);
        }
    }

    public static byte[] getOrLoadAsBytes(Project project, FilePath path, VcsRevisionNumber number, VcsKey vcsKey, UniqueType type, Throwable2Computable<byte[], VcsException, IOException> loader) throws VcsException, IOException {
        ContentRevisionCache cache = ProjectLevelVcsManager.getInstance(project).getContentRevisionCache();
        byte[] bytes = cache.getBytes(path, number, vcsKey, type);
        if (bytes != null) {
            return bytes;
        }
        ContentRevisionCache.checkLocalFileSize(path);
        bytes = (byte[])loader.compute();
        cache.put(path, number, vcsKey, type, bytes);
        return bytes;
    }

    private static void checkLocalFileSize(FilePath path) throws VcsException {
        File ioFile = path.getIOFile();
        if (ioFile.exists()) {
            ContentRevisionCache.checkContentsSize(ioFile.getPath(), ioFile.length());
        }
    }

    public static void checkContentsSize(String path, long size) throws VcsException {
        if (size > (long)VcsUtil.getMaxVcsLoadedFileSize()) {
            throw new VcsException("Can not show contents of \n'" + path + "'.\nFile size is bigger than " + StringUtil.formatFileSize((long)VcsUtil.getMaxVcsLoadedFileSize()) + ".\n\nYou can relax this restriction by increasing " + "idea.max.vcs.loaded.size.kb" + " property in idea.properties file.");
        }
    }

    public static String getOrLoadAsString(Project project, FilePath path, VcsRevisionNumber number, VcsKey vcsKey, UniqueType type, Throwable2Computable<byte[], VcsException, IOException> loader) throws VcsException, IOException {
        byte[] bytes = ContentRevisionCache.getOrLoadAsBytes(project, path, number, vcsKey, type, loader);
        if (bytes == null) {
            return null;
        }
        return ContentRevisionCache.bytesToString(path, bytes);
    }

    private static VcsRevisionNumber putIntoCurrentCache(ContentRevisionCache cache, FilePath path, VcsKey vcsKey, CurrentRevisionProvider loader) throws VcsException, IOException {
        Pair<VcsRevisionNumber, Long> currentRevision;
        VcsRevisionNumber loadedRevisionNumber;
        do {
            if (!(loadedRevisionNumber = loader.getCurrentRevision()).equals((currentRevision = cache.getCurrent(path, vcsKey)).getFirst())) continue;
            return loadedRevisionNumber;
        } while (!cache.putCurrent(path, loadedRevisionNumber, vcsKey, (Long)currentRevision.getSecond()));
        return loadedRevisionNumber;
    }

    public static Pair<VcsRevisionNumber, byte[]> getOrLoadCurrentAsBytes(Project project, FilePath path, VcsKey vcsKey, CurrentRevisionProvider loader) throws VcsException, IOException {
        VcsRevisionNumber currentRevision;
        Pair<VcsRevisionNumber, byte[]> loaded;
        ContentRevisionCache cache = ProjectLevelVcsManager.getInstance(project).getContentRevisionCache();
        do {
            byte[] cachedCurrent;
            if ((cachedCurrent = cache.getBytes(path, currentRevision = ContentRevisionCache.putIntoCurrentCache(cache, path, vcsKey, loader), vcsKey, UniqueType.REPOSITORY_CONTENT)) != null) {
                return Pair.create((Object)currentRevision, (Object)cachedCurrent);
            }
            ContentRevisionCache.checkLocalFileSize(path);
        } while (!((VcsRevisionNumber)(loaded = loader.get()).getFirst()).equals(currentRevision));
        cache.put(path, currentRevision, vcsKey, UniqueType.REPOSITORY_CONTENT, (byte[])loaded.getSecond());
        return loaded;
    }

    public static Pair<VcsRevisionNumber, String> getOrLoadCurrentAsString(Project project, FilePath path, VcsKey vcsKey, CurrentRevisionProvider loader) throws VcsException, IOException {
        Pair<VcsRevisionNumber, byte[]> pair = ContentRevisionCache.getOrLoadCurrentAsBytes(project, path, vcsKey, loader);
        return Pair.create((Object)pair.getFirst(), (Object)ContentRevisionCache.bytesToString(path, (byte[])pair.getSecond()));
    }

    public static enum UniqueType {
        REPOSITORY_CONTENT,
        REMOTE_CONTENT;

    }

    private static class Key
    extends CurrentKey {
        private final VcsRevisionNumber myNumber;
        protected final UniqueType myType;

        private Key(FilePath path, VcsRevisionNumber number, VcsKey vcsKey, UniqueType type) {
            super(path, vcsKey);
            this.myNumber = number;
            this.myType = type;
        }

        public VcsRevisionNumber getNumber() {
            return this.myNumber;
        }

        public UniqueType getType() {
            return this.myType;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Key key = (Key)o;
            if (this.myNumber != null ? !this.myNumber.equals(key.myNumber) : key.myNumber != null) {
                return false;
            }
            if (!this.myPath.equals(key.myPath)) {
                return false;
            }
            if (this.myType != key.myType) {
                return false;
            }
            return this.myVcsKey.equals(key.myVcsKey);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.myPath.hashCode();
            result = 31 * result + (this.myNumber != null ? this.myNumber.hashCode() : 0);
            result = 31 * result + this.myVcsKey.hashCode();
            result = 31 * result + this.myType.hashCode();
            return result;
        }
    }

    private static class CurrentKey {
        protected final FilePath myPath;
        protected final VcsKey myVcsKey;

        private CurrentKey(FilePath path, VcsKey vcsKey) {
            this.myPath = path;
            this.myVcsKey = vcsKey;
        }

        public FilePath getPath() {
            return this.myPath;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CurrentKey that = (CurrentKey)o;
            if (this.myPath != null ? !this.myPath.equals(that.myPath) : that.myPath != null) {
                return false;
            }
            return !(this.myVcsKey != null ? !this.myVcsKey.equals(that.myVcsKey) : that.myVcsKey != null);
        }

        public int hashCode() {
            int result = this.myPath != null ? this.myPath.hashCode() : 0;
            result = 31 * result + (this.myVcsKey != null ? this.myVcsKey.hashCode() : 0);
            return result;
        }
    }
}

