/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.util.EventDispatcher;
import java.util.EventListener;

public abstract class DeprecatedVirtualFileSystem
extends VirtualFileSystem {
    private final EventDispatcher<VirtualFileListener> myEventDispatcher = EventDispatcher.create(VirtualFileListener.class);

    protected void startEventPropagation() {
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            return;
        }
        application.getMessageBus().connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkVirtualFileListenerAdapter((VirtualFileListener)this.myEventDispatcher.getMulticaster(), this));
    }

    @Override
    public void addVirtualFileListener(VirtualFileListener listener) {
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    @Override
    public void removeVirtualFileListener(VirtualFileListener listener) {
        this.myEventDispatcher.removeListener((EventListener)listener);
    }

    protected void firePropertyChanged(Object requestor, VirtualFile file, String propertyName, Object oldValue, Object newValue) {
        this.assertWriteAccessAllowed();
        VirtualFilePropertyEvent event = new VirtualFilePropertyEvent(requestor, file, propertyName, oldValue, newValue);
        ((VirtualFileListener)this.myEventDispatcher.getMulticaster()).propertyChanged(event);
    }

    protected void fireContentsChanged(Object requestor, VirtualFile file, long oldModificationStamp) {
        this.assertWriteAccessAllowed();
        VirtualFileEvent event = new VirtualFileEvent(requestor, file, file.getParent(), oldModificationStamp, file.getModificationStamp());
        ((VirtualFileListener)this.myEventDispatcher.getMulticaster()).contentsChanged(event);
    }

    protected void fireFileCreated(Object requestor, VirtualFile file) {
        this.assertWriteAccessAllowed();
        VirtualFileEvent event = new VirtualFileEvent(requestor, file, file.getName(), file.getParent());
        ((VirtualFileListener)this.myEventDispatcher.getMulticaster()).fileCreated(event);
    }

    protected void fireFileDeleted(Object requestor, VirtualFile file, String fileName, VirtualFile parent) {
        this.assertWriteAccessAllowed();
        VirtualFileEvent event = new VirtualFileEvent(requestor, file, fileName, parent);
        ((VirtualFileListener)this.myEventDispatcher.getMulticaster()).fileDeleted(event);
    }

    protected void fireFileMoved(Object requestor, VirtualFile file, VirtualFile oldParent) {
        this.assertWriteAccessAllowed();
        VirtualFileMoveEvent event = new VirtualFileMoveEvent(requestor, file, oldParent, file.getParent());
        ((VirtualFileListener)this.myEventDispatcher.getMulticaster()).fileMoved(event);
    }

    protected void fireFileCopied(Object requestor, VirtualFile originalFile, VirtualFile createdFile) {
        this.assertWriteAccessAllowed();
        VirtualFileCopyEvent event = new VirtualFileCopyEvent(requestor, originalFile, createdFile);
        try {
            ((VirtualFileListener)this.myEventDispatcher.getMulticaster()).fileCopied(event);
        }
        catch (AbstractMethodError e) {
            ((VirtualFileListener)this.myEventDispatcher.getMulticaster()).fileCreated(event);
        }
    }

    protected void fireBeforePropertyChange(Object requestor, VirtualFile file, String propertyName, Object oldValue, Object newValue) {
        this.assertWriteAccessAllowed();
        VirtualFilePropertyEvent event = new VirtualFilePropertyEvent(requestor, file, propertyName, oldValue, newValue);
        ((VirtualFileListener)this.myEventDispatcher.getMulticaster()).beforePropertyChange(event);
    }

    protected void fireBeforeContentsChange(Object requestor, VirtualFile file) {
        this.assertWriteAccessAllowed();
        VirtualFileEvent event = new VirtualFileEvent(requestor, file, file.getName(), file.getParent());
        ((VirtualFileListener)this.myEventDispatcher.getMulticaster()).beforeContentsChange(event);
    }

    protected void fireBeforeFileDeletion(Object requestor, VirtualFile file) {
        this.assertWriteAccessAllowed();
        VirtualFileEvent event = new VirtualFileEvent(requestor, file, file.getName(), file.getParent());
        ((VirtualFileListener)this.myEventDispatcher.getMulticaster()).beforeFileDeletion(event);
    }

    protected void fireBeforeFileMovement(Object requestor, VirtualFile file, VirtualFile newParent) {
        this.assertWriteAccessAllowed();
        VirtualFileMoveEvent event = new VirtualFileMoveEvent(requestor, file, file.getParent(), newParent);
        ((VirtualFileListener)this.myEventDispatcher.getMulticaster()).beforeFileMovement(event);
    }

    protected void assertWriteAccessAllowed() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }
}

