/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.vfs.JarCopyingFileSystem;
import com.intellij.openapi.vfs.JarFile;
import com.intellij.openapi.vfs.LocalFileProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import java.io.IOException;

public abstract class JarFileSystem
extends ArchiveFileSystem
implements JarCopyingFileSystem,
LocalFileProvider {
    public static final String PROTOCOL = "jar";
    public static final String PROTOCOL_PREFIX = "jar://";
    public static final String JAR_SEPARATOR = "!/";

    public static JarFileSystem getInstance() {
        return (JarFileSystem)VirtualFileManager.getInstance().getFileSystem(PROTOCOL);
    }

    public VirtualFile getVirtualFileForJar(VirtualFile entryFile) {
        return entryFile == null ? null : this.getLocalByEntry(entryFile);
    }

    public VirtualFile getJarRootForLocalFile(VirtualFile file) {
        return this.getRootByLocal(file);
    }

    public abstract JarFile getJarFile(VirtualFile var1) throws IOException;

    @Override
    public VirtualFile getLocalVirtualFileFor(VirtualFile entryVFile) {
        return this.getVirtualFileForJar(entryVFile);
    }

    @Override
    public VirtualFile findLocalVirtualFileByPath(String path) {
        if (!path.contains(JAR_SEPARATOR)) {
            path = path + JAR_SEPARATOR;
        }
        return this.findFileByPath(path);
    }
}

