/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.LocalFileOperationsHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.util.Processor;
import com.intellij.util.io.fs.IFile;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NonNls;

public abstract class LocalFileSystem
extends NewVirtualFileSystem {
    @NonNls
    public static final String PROTOCOL = "file";
    @NonNls
    public static final String PROTOCOL_PREFIX = "file://";

    public static LocalFileSystem getInstance() {
        return LocalFileSystemHolder.ourInstance;
    }

    @Override
    public boolean isSymLink(VirtualFile file) {
        return false;
    }

    @Override
    public boolean isSpecialFile(VirtualFile file) {
        return false;
    }

    public abstract VirtualFile findFileByIoFile(File var1);

    public abstract VirtualFile findFileByIoFile(IFile var1);

    public abstract VirtualFile refreshAndFindFileByIoFile(File var1);

    public abstract VirtualFile refreshAndFindFileByIoFile(IFile var1);

    public abstract void refreshIoFiles(Iterable<File> var1);

    public abstract void refreshIoFiles(Iterable<File> var1, boolean var2, boolean var3, Runnable var4);

    public abstract void refreshFiles(Iterable<VirtualFile> var1);

    public abstract void refreshFiles(Iterable<VirtualFile> var1, boolean var2, boolean var3, Runnable var4);

    public final VirtualFile getRoot() {
        VirtualFile[] roots = ManagingFS.getInstance().getLocalRoots();
        assert (roots.length > 0) : SystemInfo.OS_NAME;
        return roots[0];
    }

    public WatchRequest addRootToWatch(String rootPath, boolean watchRecursively) {
        Set<WatchRequest> result = this.addRootsToWatch(Collections.singleton(rootPath), watchRecursively);
        return result.size() == 1 ? result.iterator().next() : null;
    }

    public abstract Set<WatchRequest> addRootsToWatch(Collection<String> var1, boolean var2);

    public void removeWatchedRoot(WatchRequest watchRequest) {
        if (watchRequest != null) {
            this.removeWatchedRoots(Collections.singleton(watchRequest));
        }
    }

    public abstract void removeWatchedRoots(Collection<WatchRequest> var1);

    public WatchRequest replaceWatchedRoot(WatchRequest watchRequest, String rootPath, boolean watchRecursively) {
        Set<WatchRequest> requests = watchRequest != null ? Collections.singleton(watchRequest) : Collections.emptySet();
        Set<WatchRequest> result = watchRecursively ? this.replaceWatchedRoots(requests, Collections.singleton(rootPath), null) : this.replaceWatchedRoots(requests, null, Collections.singleton(rootPath));
        return result.size() == 1 ? result.iterator().next() : null;
    }

    public abstract Set<WatchRequest> replaceWatchedRoots(Collection<WatchRequest> var1, Collection<String> var2, Collection<String> var3);

    public abstract void registerAuxiliaryFileOperationsHandler(LocalFileOperationsHandler var1);

    public abstract void unregisterAuxiliaryFileOperationsHandler(LocalFileOperationsHandler var1);

    public abstract boolean processCachedFilesInSubtree(VirtualFile var1, Processor<VirtualFile> var2);

    public static interface WatchRequest {
        public String getRootPath();

        public boolean isToWatchRecursively();
    }

    private static class LocalFileSystemHolder {
        private static final LocalFileSystem ourInstance = (LocalFileSystem)VirtualFileManager.getInstance().getFileSystem("file");

        private LocalFileSystemHolder() {
        }
    }
}

