/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.util.Collection;

public abstract class ReadonlyStatusHandler {
    public static boolean ensureFilesWritable(Project project, VirtualFile ... files) {
        return !ReadonlyStatusHandler.getInstance(project).ensureFilesWritable(files).hasReadonlyFiles();
    }

    public static boolean ensureDocumentWritable(Project project, Document document) {
        VirtualFile virtualFile;
        PsiFile psiFile = PsiDocumentManager.getInstance(project).getPsiFile(document);
        boolean okWritable = psiFile == null ? document.isWritable() : ((virtualFile = psiFile.getVirtualFile()) != null ? ReadonlyStatusHandler.ensureFilesWritable(project, virtualFile) : psiFile.isWritable());
        return okWritable;
    }

    public abstract OperationStatus ensureFilesWritable(VirtualFile ... var1);

    public OperationStatus ensureFilesWritable(Collection<VirtualFile> files) {
        return this.ensureFilesWritable(VfsUtilCore.toVirtualFileArray(files));
    }

    public static ReadonlyStatusHandler getInstance(Project project) {
        return ServiceManager.getService(project, ReadonlyStatusHandler.class);
    }

    public static abstract class OperationStatus {
        public abstract VirtualFile[] getReadonlyFiles();

        public abstract boolean hasReadonlyFiles();

        public abstract String getReadonlyFilesMessage();
    }
}

