/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import gnu.trove.THashSet;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;

public class VfsUtil
extends VfsUtilCore {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.VfsUtil");
    public static final char VFS_PATH_SEPARATOR = '/';

    public static void saveText(VirtualFile file, String text) throws IOException {
        Charset charset = file.getCharset();
        file.setBinaryContent(text.getBytes(charset.name()));
    }

    public static void copyDirectory(Object requestor, VirtualFile fromDir, VirtualFile toDir, VirtualFileFilter filter) throws IOException {
        VirtualFile[] children;
        for (VirtualFile child : children = fromDir.getChildren()) {
            if (child.is(VFileProperty.SYMLINK) || child.is(VFileProperty.SPECIAL) || filter != null && !filter.accept(child)) continue;
            if (!child.isDirectory()) {
                VfsUtil.copyFile(requestor, child, toDir);
                continue;
            }
            VirtualFile newChild = toDir.findChild(child.getName());
            if (newChild == null) {
                newChild = toDir.createChildDirectory(requestor, child.getName());
            }
            VfsUtil.copyDirectory(requestor, child, newChild, filter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFromResource(VirtualFile file, @NonNls String resourceUrl) throws IOException {
        InputStream out = VfsUtil.class.getResourceAsStream(resourceUrl);
        if (out == null) {
            throw new FileNotFoundException(resourceUrl);
        }
        try {
            byte[] bytes = FileUtil.adaptiveLoadBytes((InputStream)out);
            file.setBinaryContent(bytes);
        }
        finally {
            out.close();
        }
    }

    public static VirtualFile copy(Object requestor, VirtualFile file, VirtualFile toDir) throws IOException {
        if (file.isDirectory()) {
            VirtualFile newDir = toDir.createChildDirectory(requestor, file.getName());
            VfsUtil.copyDirectory(requestor, file, newDir, null);
            return newDir;
        }
        return VfsUtil.copyFile(requestor, file, toDir);
    }

    public static VirtualFile[] getCommonAncestors(VirtualFile[] files) {
        HashMap<VirtualFile, Object> map = new HashMap<VirtualFile, Object>();
        for (VirtualFile aFile : files) {
            Object filesSet;
            VirtualFile directory;
            VirtualFile virtualFile = directory = aFile.isDirectory() ? aFile : aFile.getParent();
            if (directory == null) {
                return VirtualFile.EMPTY_ARRAY;
            }
            VirtualFile[] path = VfsUtil.getPathComponents(directory);
            VirtualFile firstPart = path[0];
            if (map.containsKey(firstPart)) {
                filesSet = (Set)map.get(firstPart);
            } else {
                filesSet = new THashSet();
                map.put(firstPart, filesSet);
            }
            filesSet.add(directory);
        }
        ArrayList<VirtualFile> ancestorsList = new ArrayList<VirtualFile>();
        for (Set filesSet : map.values()) {
            VirtualFile ancestor = null;
            for (VirtualFile file : filesSet) {
                if (ancestor == null) {
                    ancestor = file;
                    continue;
                }
                ancestor = VfsUtil.getCommonAncestor(ancestor, file);
            }
            ancestorsList.add(ancestor);
            filesSet.clear();
        }
        return VfsUtil.toVirtualFileArray(ancestorsList);
    }

    public static VirtualFile getCommonAncestor(Collection<? extends VirtualFile> files) {
        VirtualFile ancestor = null;
        for (VirtualFile virtualFile : files) {
            if (ancestor == null) {
                ancestor = virtualFile;
                continue;
            }
            if ((ancestor = VfsUtil.getCommonAncestor(ancestor, virtualFile)) != null) continue;
            return null;
        }
        return ancestor;
    }

    public static VirtualFile findRelativeFile(VirtualFile base, String ... path) {
        VirtualFile file = base;
        for (String pathElement : path) {
            if (file == null) {
                return null;
            }
            file = "..".equals(pathElement) ? file.getParent() : file.findChild(pathElement);
        }
        return file;
    }

    public static VirtualFile findFileByURL(URL url) {
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        return VfsUtil.findFileByURL(url, virtualFileManager);
    }

    public static VirtualFile findFileByURL(URL url, VirtualFileManager virtualFileManager) {
        String vfUrl = VfsUtil.convertFromUrl(url);
        return virtualFileManager.findFileByUrl(vfUrl);
    }

    public static VirtualFile findFileByIoFile(File file, boolean refreshIfNeeded) {
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        VirtualFile virtualFile = fileSystem.findFileByIoFile(file);
        if (refreshIfNeeded && (virtualFile == null || !virtualFile.isValid())) {
            virtualFile = fileSystem.refreshAndFindFileByIoFile(file);
        }
        return virtualFile;
    }

    public static URL convertToURL(String vfsUrl) {
        return VfsUtilCore.convertToURL(vfsUrl);
    }

    public static VirtualFile copyFileRelative(Object requestor, VirtualFile file, VirtualFile toDir, String relativePath) throws IOException {
        String token;
        StringTokenizer tokenizer = new StringTokenizer(relativePath, "/");
        VirtualFile curDir = toDir;
        while (true) {
            token = tokenizer.nextToken();
            if (!tokenizer.hasMoreTokens()) break;
            VirtualFile childDir = curDir.findChild(token);
            if (childDir == null) {
                childDir = curDir.createChildDirectory(requestor, token);
            }
            curDir = childDir;
        }
        return VfsUtil.copyFile(requestor, file, curDir, token);
    }

    public static String toIdeaUrl(String url) {
        return VfsUtil.toIdeaUrl(url, true);
    }

    public static URI toUri(VirtualFile file) {
        String path = file.getPath();
        try {
            if (file.isInLocalFileSystem()) {
                if (SystemInfo.isWindows && path.charAt(0) != '/') {
                    path = '/' + path;
                }
                return new URI(file.getFileSystem().getProtocol(), "", path, null, null);
            }
            return new URI(file.getFileSystem().getProtocol(), path, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static URI toUri(File file) {
        String path = file.toURI().getPath();
        try {
            if (SystemInfo.isWindows && path.charAt(0) != '/') {
                path = '/' + path;
            }
            return new URI("file", "", path, null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static URI toUri(@NonNls String uri) {
        int firstSlashIndex;
        int index = uri.indexOf("://");
        if (index < 0) {
            try {
                return new URI(uri);
            }
            catch (URISyntaxException e) {
                LOG.debug((Throwable)e);
                return null;
            }
        }
        if (SystemInfo.isWindows && uri.startsWith("file://") && uri.charAt(firstSlashIndex = index + "://".length()) != '/') {
            uri = "file:///" + uri.substring(firstSlashIndex);
        }
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            LOG.debug("uri is not fully encoded", (Throwable)e);
            try {
                int fragmentIndex = uri.lastIndexOf(35);
                String path = uri.substring(index + 1, fragmentIndex > 0 ? fragmentIndex : uri.length());
                String fragment = fragmentIndex > 0 ? uri.substring(fragmentIndex + 1) : null;
                return new URI(uri.substring(0, index), path, fragment);
            }
            catch (URISyntaxException e1) {
                LOG.debug((Throwable)e1);
                return null;
            }
        }
    }

    public static String getPath(VirtualFile src, VirtualFile dst, char separatorChar) {
        VirtualFile commonAncestor = VfsUtil.getCommonAncestor(src, dst);
        if (commonAncestor != null) {
            StringBuilder buffer = new StringBuilder();
            if (!Comparing.equal((Object)src, (Object)commonAncestor)) {
                while (!Comparing.equal((Object)src.getParent(), (Object)commonAncestor)) {
                    buffer.append("..").append(separatorChar);
                    src = src.getParent();
                }
            }
            buffer.append(VfsUtil.getRelativePath(dst, commonAncestor, separatorChar));
            return buffer.toString();
        }
        return null;
    }

    public static String getUrlForLibraryRoot(File libraryRoot) {
        String path = FileUtil.toSystemIndependentName((String)libraryRoot.getAbsolutePath());
        if (FileTypeManager.getInstance().getFileTypeByFileName(libraryRoot.getName()) == FileTypes.ARCHIVE) {
            return VirtualFileManager.constructUrl(JarFileSystem.getInstance().getProtocol(), path + "!/");
        }
        return VirtualFileManager.constructUrl(LocalFileSystem.getInstance().getProtocol(), path);
    }

    public static VirtualFile createChildSequent(Object requestor, VirtualFile dir, String prefix, String extension) throws IOException {
        String dotExt = PathUtil.makeFileName("", extension);
        String fileName = prefix + dotExt;
        int i = 1;
        while (dir.findChild(fileName) != null) {
            fileName = prefix + "_" + i + dotExt;
            ++i;
        }
        return dir.createChildData(requestor, fileName);
    }

    public static String[] filterNames(String[] names) {
        int filteredCount = 0;
        for (String string : names) {
            if (!VfsUtil.isBadName(string)) continue;
            ++filteredCount;
        }
        if (filteredCount == 0) {
            return names;
        }
        String[] result = ArrayUtil.newStringArray((int)(names.length - filteredCount));
        int count = 0;
        for (String string : names) {
            if (VfsUtil.isBadName(string)) continue;
            result[count++] = string;
        }
        return result;
    }

    public static boolean isBadName(String name) {
        return name == null || name.isEmpty() || "/".equals(name) || "\\".equals(name);
    }

    public static VirtualFile createDirectories(final String directoryPath) throws IOException {
        return (VirtualFile)new WriteAction<VirtualFile>(){

            @Override
            protected void run(Result<VirtualFile> result) throws Throwable {
                VirtualFile res = VfsUtil.createDirectoryIfMissing(directoryPath);
                result.setResult(res);
            }
        }.execute().throwException().getResultObject();
    }

    public static VirtualFile createDirectoryIfMissing(VirtualFile parent, String relativePath) throws IOException {
        for (String each : StringUtil.split((String)relativePath, (String)"/")) {
            VirtualFile child = parent.findChild(each);
            if (child == null) {
                child = parent.createChildDirectory(LocalFileSystem.getInstance(), each);
            }
            parent = child;
        }
        return parent;
    }

    public static VirtualFile createDirectoryIfMissing(String directoryPath) throws IOException {
        String path = FileUtil.toSystemIndependentName((String)directoryPath);
        VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
        if (file == null) {
            int pos = path.lastIndexOf(47);
            if (pos < 0) {
                return null;
            }
            VirtualFile parent = VfsUtil.createDirectoryIfMissing(path.substring(0, pos));
            if (parent == null) {
                return null;
            }
            String dirName = path.substring(pos + 1);
            return parent.createChildDirectory(LocalFileSystem.getInstance(), dirName);
        }
        return file;
    }

    public static List<VirtualFile> collectChildrenRecursively(VirtualFile root) {
        final ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        VfsUtil.processFilesRecursively(root, new Processor<VirtualFile>(){

            public boolean process(VirtualFile t) {
                result.add(t);
                return true;
            }
        });
        return result;
    }

    public static void processFileRecursivelyWithoutIgnored(VirtualFile root, Processor<VirtualFile> processor) {
        final FileTypeManager ftm = FileTypeManager.getInstance();
        VfsUtil.processFilesRecursively(root, processor, new Convertor<VirtualFile, Boolean>(){

            public Boolean convert(VirtualFile vf) {
                return !ftm.isFileIgnored(vf);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T processInputStream(VirtualFile file, Function<InputStream, T> function) {
        InputStream stream = null;
        try {
            stream = file.getInputStream();
            Object object = function.fun((Object)stream);
            return (T)object;
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        return null;
    }

    public static String getReadableUrl(VirtualFile file) {
        String url = null;
        if (file.isInLocalFileSystem()) {
            url = file.getPresentableUrl();
        }
        if (url == null) {
            url = file.getUrl();
        }
        return url;
    }

    public static VirtualFile getUserHomeDir() {
        String path = SystemProperties.getUserHome();
        return LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)path));
    }

    public static VirtualFile[] getChildren(VirtualFile dir) {
        VirtualFile[] children = dir.getChildren();
        return children == null ? VirtualFile.EMPTY_ARRAY : children;
    }

    public static String getParentDir(String url) {
        if (url == null) {
            return null;
        }
        int index = url.lastIndexOf(47);
        return index < 0 ? null : url.substring(0, index);
    }

    public static String extractFileName(String urlOrPath) {
        if (urlOrPath == null) {
            return null;
        }
        int index = urlOrPath.lastIndexOf(47);
        return index < 0 ? null : urlOrPath.substring(index + 1);
    }

    public static List<VirtualFile> markDirty(boolean recursive, boolean reloadChildren, VirtualFile ... files) {
        List list = ContainerUtil.filter((Condition)Condition.NOT_NULL, (Object[])files);
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        for (VirtualFile file : list) {
            if (reloadChildren) {
                file.getChildren();
            }
            if (!(file instanceof NewVirtualFile)) continue;
            if (recursive) {
                ((NewVirtualFile)file).markDirtyRecursively();
                continue;
            }
            ((NewVirtualFile)file).markDirty();
        }
        return list;
    }

    public static void markDirtyAndRefresh(boolean async, boolean recursive, boolean reloadChildren, VirtualFile ... files) {
        List<VirtualFile> list = VfsUtil.markDirty(recursive, reloadChildren, files);
        if (list.isEmpty()) {
            return;
        }
        LocalFileSystem.getInstance().refreshFiles(list, async, recursive, null);
    }
}

