/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsBundle;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.encoding.EncodingRegistry;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NonNls;

public abstract class VirtualFile
extends UserDataHolderBase
implements ModificationTracker {
    public static final Key<Object> REQUESTOR_MARKER = Key.create((String)"REQUESTOR_MARKER");
    public static final VirtualFile[] EMPTY_ARRAY = new VirtualFile[0];
    @NonNls
    public static final String PROP_NAME = "name";
    @NonNls
    public static final String PROP_ENCODING = "encoding";
    @NonNls
    public static final String PROP_WRITABLE = "writable";
    @NonNls
    public static final String PROP_HIDDEN = VFileProperty.HIDDEN.getName();
    @NonNls
    public static final String PROP_SYMLINK_TARGET = "symlink";
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.VirtualFile");
    private static final Key<byte[]> BOM_KEY = Key.create((String)"BOM");
    private static final Key<Charset> CHARSET_KEY = Key.create((String)"CHARSET");
    private static final Key<String> DETECTED_LINE_SEPARATOR_KEY = Key.create((String)"DETECTED_LINE_SEPARATOR_KEY");

    protected VirtualFile() {
    }

    @NonNls
    public abstract String getName();

    public abstract VirtualFileSystem getFileSystem();

    public abstract String getPath();

    public String getUrl() {
        return VirtualFileManager.constructUrl(this.getFileSystem().getProtocol(), this.getPath());
    }

    public final String getPresentableUrl() {
        return this.getFileSystem().extractPresentableUrl(this.getPath());
    }

    @NonNls
    public String getExtension() {
        String name = this.getName();
        int index = name.lastIndexOf(46);
        if (index < 0) {
            return null;
        }
        return name.substring(index + 1);
    }

    @NonNls
    public String getNameWithoutExtension() {
        String name = this.getName();
        int index = name.lastIndexOf(46);
        if (index < 0) {
            return name;
        }
        return name.substring(0, index);
    }

    public void rename(Object requestor, @NonNls String newName) throws IOException {
        if (this.getName().equals(newName)) {
            return;
        }
        if (!VirtualFile.isValidName(newName)) {
            throw new IOException(VfsBundle.message("file.invalid.name.error", newName));
        }
        this.getFileSystem().renameFile(requestor, this, newName);
    }

    public abstract boolean isWritable();

    public void setWritable(boolean writable) throws IOException {
        throw new IOException("Not supported");
    }

    public abstract boolean isDirectory();

    public boolean isSymLink() {
        return this.is(VFileProperty.SYMLINK);
    }

    public boolean isSpecialFile() {
        return this.is(VFileProperty.SPECIAL);
    }

    public boolean is(VFileProperty property) {
        return false;
    }

    public String getCanonicalPath() {
        return this.getPath();
    }

    public VirtualFile getCanonicalFile() {
        return this;
    }

    public abstract boolean isValid();

    public abstract VirtualFile getParent();

    public abstract VirtualFile[] getChildren();

    public VirtualFile findChild(@NonNls String name) {
        VirtualFile[] children = this.getChildren();
        if (children == null) {
            return null;
        }
        for (VirtualFile child : children) {
            if (!child.nameEquals(name)) continue;
            return child;
        }
        return null;
    }

    public VirtualFile findOrCreateChildData(Object requestor, @NonNls String name) throws IOException {
        VirtualFile child = this.findChild(name);
        if (child != null) {
            return child;
        }
        return this.createChildData(requestor, name);
    }

    public FileType getFileType() {
        return FileTypeRegistry.getInstance().getFileTypeByFile(this);
    }

    public VirtualFile findFileByRelativePath(@NonNls String relPath) {
        VirtualFile canonicalFile;
        String name;
        if (relPath.isEmpty()) {
            return this;
        }
        int index = (relPath = StringUtil.trimStart((String)relPath, (String)"/")).indexOf(47);
        if (index < 0) {
            index = relPath.length();
        }
        VirtualFile child = (name = relPath.substring(0, index)).equals(".") ? this : (name.equals("..") ? (this.is(VFileProperty.SYMLINK) ? ((canonicalFile = this.getCanonicalFile()) != null ? canonicalFile.getParent() : null) : this.getParent()) : this.findChild(name));
        if (child == null) {
            return null;
        }
        if (index < relPath.length()) {
            return child.findFileByRelativePath(relPath.substring(index + 1));
        }
        return child;
    }

    public VirtualFile createChildDirectory(Object requestor, @NonNls String name) throws IOException {
        if (!this.isDirectory()) {
            throw new IOException(VfsBundle.message("directory.create.wrong.parent.error", new Object[0]));
        }
        if (!this.isValid()) {
            throw new IOException(VfsBundle.message("invalid.directory.create.files", new Object[0]));
        }
        if (!VirtualFile.isValidName(name)) {
            throw new IOException(VfsBundle.message("directory.invalid.name.error", name));
        }
        if (this.findChild(name) != null) {
            throw new IOException(VfsBundle.message("file.create.already.exists.error", this.getUrl(), name));
        }
        return this.getFileSystem().createChildDirectory(requestor, this, name);
    }

    public VirtualFile createChildData(Object requestor, @NonNls String name) throws IOException {
        if (!this.isDirectory()) {
            throw new IOException(VfsBundle.message("file.create.wrong.parent.error", new Object[0]));
        }
        if (!this.isValid()) {
            throw new IOException(VfsBundle.message("invalid.directory.create.files", new Object[0]));
        }
        if (!VirtualFile.isValidName(name)) {
            throw new IOException(VfsBundle.message("file.invalid.name.error", name));
        }
        if (this.findChild(name) != null) {
            throw new IOException(VfsBundle.message("file.create.already.exists.error", this.getUrl(), name));
        }
        return this.getFileSystem().createChildFile(requestor, this, name);
    }

    public void delete(Object requestor) throws IOException {
        LOG.assertTrue(this.isValid(), (Object)"Deleting invalid file");
        this.getFileSystem().deleteFile(requestor, this);
    }

    public void move(final Object requestor, final VirtualFile newParent) throws IOException {
        if (this.getFileSystem() != newParent.getFileSystem()) {
            throw new IOException(VfsBundle.message("file.move.error", newParent.getPresentableUrl()));
        }
        EncodingRegistry.doActionAndRestoreEncoding(this, new ThrowableComputable<VirtualFile, IOException>(){

            public VirtualFile compute() throws IOException {
                VirtualFile.this.getFileSystem().moveFile(requestor, VirtualFile.this, newParent);
                return VirtualFile.this;
            }
        });
    }

    public VirtualFile copy(final Object requestor, final VirtualFile newParent, final String copyName) throws IOException {
        if (this.getFileSystem() != newParent.getFileSystem()) {
            throw new IOException(VfsBundle.message("file.copy.error", newParent.getPresentableUrl()));
        }
        if (!newParent.isDirectory()) {
            throw new IOException(VfsBundle.message("file.copy.target.must.be.directory", new Object[0]));
        }
        return EncodingRegistry.doActionAndRestoreEncoding(this, new ThrowableComputable<VirtualFile, IOException>(){

            public VirtualFile compute() throws IOException {
                return VirtualFile.this.getFileSystem().copyFile(requestor, VirtualFile.this, newParent, copyName);
            }
        });
    }

    public Charset getCharset() {
        Charset charset = this.getStoredCharset();
        if (charset == null) {
            charset = EncodingRegistry.getInstance().getDefaultCharset();
            this.setCharset(charset);
        }
        return charset;
    }

    protected Charset getStoredCharset() {
        return (Charset)this.getUserData(CHARSET_KEY);
    }

    protected void storeCharset(Charset charset) {
        this.putUserData(CHARSET_KEY, charset);
    }

    public void setCharset(Charset charset) {
        this.setCharset(charset, null);
    }

    public void setCharset(Charset charset, Runnable whenChanged) {
        Charset old = this.getStoredCharset();
        this.storeCharset(charset);
        if (Comparing.equal((Object)charset, (Object)old)) {
            return;
        }
        byte[] bom = charset == null ? null : CharsetToolkit.getMandatoryBom((Charset)charset);
        byte[] existingBOM = this.getBOM();
        if (bom == null && charset != null && existingBOM != null) {
            bom = (byte[])(CharsetToolkit.canHaveBom((Charset)charset, (byte[])existingBOM) ? existingBOM : null);
        }
        this.setBOM(bom);
        if (old != null) {
            if (whenChanged != null) {
                whenChanged.run();
            }
            VirtualFileManager.getInstance().notifyPropertyChanged(this, PROP_ENCODING, old, charset);
        }
    }

    public boolean isCharsetSet() {
        return this.getStoredCharset() != null;
    }

    public final void setBinaryContent(byte[] content) throws IOException {
        this.setBinaryContent(content, -1L, -1L);
    }

    public void setBinaryContent(byte[] content, long newModificationStamp, long newTimeStamp) throws IOException {
        this.setBinaryContent(content, newModificationStamp, newTimeStamp, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBinaryContent(byte[] content, long newModificationStamp, long newTimeStamp, Object requestor) throws IOException {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        OutputStream outputStream = this.getOutputStream(requestor, newModificationStamp, newTimeStamp);
        try {
            outputStream.write(content);
            outputStream.flush();
        }
        finally {
            outputStream.close();
        }
    }

    public final OutputStream getOutputStream(Object requestor) throws IOException {
        return this.getOutputStream(requestor, -1L, -1L);
    }

    public abstract OutputStream getOutputStream(Object var1, long var2, long var4) throws IOException;

    public abstract byte[] contentsToByteArray() throws IOException;

    public byte[] contentsToByteArray(boolean cacheContent) throws IOException {
        return this.contentsToByteArray();
    }

    public long getModificationStamp() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public abstract long getTimeStamp();

    public abstract long getLength();

    public void refresh(boolean asynchronous, boolean recursive) {
        this.refresh(asynchronous, recursive, null);
    }

    public abstract void refresh(boolean var1, boolean var2, Runnable var3);

    public String getPresentableName() {
        return this.getName();
    }

    @Override
    public long getModificationCount() {
        return this.isValid() ? this.getTimeStamp() : -1L;
    }

    protected boolean nameEquals(@NonNls String name) {
        return this.getName().equals(name);
    }

    public abstract InputStream getInputStream() throws IOException;

    public byte[] getBOM() {
        return (byte[])this.getUserData(BOM_KEY);
    }

    public void setBOM(byte[] BOM) {
        this.putUserData(BOM_KEY, BOM);
    }

    @NonNls
    public String toString() {
        return "VirtualFile: " + this.getPresentableUrl();
    }

    public boolean exists() {
        return this.isValid();
    }

    public boolean isInLocalFileSystem() {
        return false;
    }

    public static boolean isValidName(String name) {
        return name.length() > 0 && name.indexOf(92) < 0 && name.indexOf(47) < 0;
    }

    public String getDetectedLineSeparator() {
        return (String)this.getUserData(DETECTED_LINE_SEPARATOR_KEY);
    }

    public void setDetectedLineSeparator(String separator) {
        this.putUserData(DETECTED_LINE_SEPARATOR_KEY, separator);
    }

    public CharSequence getNameSequence() {
        return this.getName();
    }
}

