/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;

public class VirtualFileWrapper {
    private final File myFile;

    public VirtualFileWrapper(File file) {
        this.myFile = file;
    }

    public boolean exists() {
        return this.myFile.exists();
    }

    public VirtualFile getVirtualFile() {
        return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(this.myFile);
    }

    public VirtualFile getVirtualFile(boolean createIfNotExist) {
        if (createIfNotExist && !this.myFile.exists()) {
            try {
                if (!this.myFile.createNewFile()) {
                    return null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.getVirtualFile();
    }

    public File getFile() {
        return this.myFile;
    }
}

