/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.encoding;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import java.nio.charset.Charset;

public abstract class EncodingRegistry {
    public abstract boolean isNative2Ascii(VirtualFile var1);

    public abstract boolean isNative2AsciiForPropertiesFiles();

    public abstract Charset getDefaultCharset();

    public abstract Charset getEncoding(VirtualFile var1, boolean var2);

    @Deprecated
    public abstract boolean isUseUTFGuessing(VirtualFile var1);

    public abstract void setEncoding(VirtualFile var1, Charset var2);

    public Charset getDefaultCharsetForPropertiesFiles(VirtualFile virtualFile) {
        return null;
    }

    public static EncodingRegistry getInstance() {
        return EncodingManager.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E extends Throwable> VirtualFile doActionAndRestoreEncoding(VirtualFile fileBefore, ThrowableComputable<VirtualFile, E> action) throws E {
        EncodingRegistry registry = EncodingRegistry.getInstance();
        Charset charsetBefore = registry.getEncoding(fileBefore, true);
        VirtualFile fileAfter = null;
        try {
            VirtualFile virtualFile = fileAfter = (VirtualFile)action.compute();
            return virtualFile;
        }
        finally {
            Charset actual;
            if (fileAfter != null && !Comparing.equal((Object)(actual = registry.getEncoding(fileAfter, true)), (Object)charsetBefore)) {
                registry.setEncoding(fileAfter, charsetBefore);
            }
        }
    }
}

