/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;

public abstract class ArchiveHandler {
    public static final long DEFAULT_LENGTH = 0L;
    public static final long DEFAULT_TIMESTAMP = -1L;
    private final String myPath;
    private final Object myLock = new Object();
    private volatile Reference<Map<String, EntryInfo>> myEntries = new SoftReference(null);
    private boolean myCorrupted = false;

    protected ArchiveHandler(String path) {
        this.myPath = path;
    }

    public File getFile() {
        return new File(this.myPath);
    }

    public FileAttributes getAttributes(String relativePath) {
        if (relativePath.isEmpty()) {
            FileAttributes attributes = FileSystemUtil.getAttributes((String)this.myPath);
            return attributes != null ? new FileAttributes(true, false, false, false, 0L, -1L, false) : null;
        }
        EntryInfo entry = this.getEntryInfo(relativePath);
        return entry != null ? new FileAttributes(entry.isDirectory, false, false, false, entry.length, entry.timestamp, false) : null;
    }

    public String[] list(String relativePath) {
        EntryInfo entry = this.getEntryInfo(relativePath);
        if (entry == null || !entry.isDirectory) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        HashSet<String> names = new HashSet<String>();
        for (EntryInfo info : this.getEntriesMap().values()) {
            if (info.parent != entry) continue;
            names.add(info.shortName);
        }
        return ArrayUtil.toStringArray(names);
    }

    protected EntryInfo getEntryInfo(String relativePath) {
        return this.getEntriesMap().get(relativePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, EntryInfo> getEntriesMap() {
        Map<Object, Object> map = (Map)SoftReference.dereference(this.myEntries);
        if (map == null) {
            Object object = this.myLock;
            synchronized (object) {
                map = (Map)SoftReference.dereference(this.myEntries);
                if (map == null) {
                    if (this.myCorrupted) {
                        map = Collections.emptyMap();
                    } else {
                        try {
                            map = Collections.unmodifiableMap(this.createEntriesMap());
                        }
                        catch (Exception e) {
                            this.myCorrupted = true;
                            Logger.getInstance(this.getClass()).warn(e.getMessage() + ": " + this.myPath, (Throwable)e);
                            map = Collections.emptyMap();
                        }
                    }
                    this.myEntries = new SoftReference(map);
                }
            }
        }
        return map;
    }

    protected abstract Map<String, EntryInfo> createEntriesMap() throws IOException;

    protected EntryInfo createRootEntry() {
        return new EntryInfo(null, "", true, 0L, -1L);
    }

    protected EntryInfo getOrCreate(Map<String, EntryInfo> map, String entryName) {
        EntryInfo entry = map.get(entryName);
        if (entry == null) {
            Pair<String, String> path = this.splitPath(entryName);
            EntryInfo parentEntry = this.getOrCreate(map, (String)path.first);
            entry = new EntryInfo(parentEntry, (String)path.second, true, 0L, -1L);
            map.put(entryName, entry);
        }
        return entry;
    }

    protected Pair<String, String> splitPath(String entryName) {
        int p = entryName.lastIndexOf(47);
        String parentName = p > 0 ? entryName.substring(0, p) : "";
        String shortName = p > 0 ? entryName.substring(p + 1) : entryName;
        return Pair.create((Object)parentName, (Object)shortName);
    }

    public abstract byte[] contentsToByteArray(String var1) throws IOException;

    protected static class EntryInfo {
        public final EntryInfo parent;
        public final String shortName;
        public final boolean isDirectory;
        public final long length;
        public final long timestamp;

        public EntryInfo(EntryInfo parent, String shortName, boolean isDirectory, long length, long timestamp) {
            this.parent = parent;
            this.shortName = shortName;
            this.isDirectory = isDirectory;
            this.length = length;
            this.timestamp = timestamp;
        }
    }
}

