/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.events;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import org.jetbrains.annotations.NonNls;

public class VFilePropertyChangeEvent
extends VFileEvent {
    private final VirtualFile myFile;
    private final String myPropertyName;
    private final Object myOldValue;
    private final Object myNewValue;

    public VFilePropertyChangeEvent(Object requestor, VirtualFile file, String propertyName, Object oldValue, Object newValue, boolean isFromRefresh) {
        super(requestor, isFromRefresh);
        this.myFile = file;
        this.myPropertyName = propertyName;
        this.myOldValue = oldValue;
        this.myNewValue = newValue;
        VFilePropertyChangeEvent.checkPropertyValuesCorrect(requestor, propertyName, oldValue, newValue);
    }

    public static void checkPropertyValuesCorrect(Object requestor, String propertyName, Object oldValue, Object newValue) {
        if (Comparing.equal((Object)oldValue, (Object)newValue) && "FileContentUtilCore.saveOrReload" != requestor) {
            throw new IllegalArgumentException("Values must be different, got the same: " + oldValue);
        }
        if ("name".equals(propertyName)) {
            if (oldValue == null) {
                throw new IllegalArgumentException("oldName must not be null");
            }
            if (newValue == null) {
                throw new IllegalArgumentException("newName must not be null");
            }
        } else if ("encoding".equals(propertyName)) {
            if (oldValue == null) {
                throw new IllegalArgumentException("oldCharset must not be null");
            }
        } else if ("writable".equals(propertyName)) {
            if (!(oldValue instanceof Boolean)) {
                throw new IllegalArgumentException("oldWriteable must be boolean, got " + oldValue);
            }
            if (!(newValue instanceof Boolean)) {
                throw new IllegalArgumentException("newWriteable must be boolean, got " + newValue);
            }
        } else if (VirtualFile.PROP_HIDDEN.equals(propertyName)) {
            if (!(oldValue instanceof Boolean)) {
                throw new IllegalArgumentException("oldHidden must be boolean, got " + oldValue);
            }
            if (!(newValue instanceof Boolean)) {
                throw new IllegalArgumentException("newHidden must be boolean, got " + newValue);
            }
        } else if ("symlink".equals(propertyName)) {
            if (oldValue != null && !(oldValue instanceof String)) {
                throw new IllegalArgumentException("oldSymTarget must be String, got " + oldValue);
            }
            if (newValue != null && !(newValue instanceof String)) {
                throw new IllegalArgumentException("newSymTarget must be String, got " + newValue);
            }
        }
    }

    @Override
    public VirtualFile getFile() {
        return this.myFile;
    }

    public Object getNewValue() {
        return this.myNewValue;
    }

    public Object getOldValue() {
        return this.myOldValue;
    }

    public String getPropertyName() {
        return this.myPropertyName;
    }

    @Override
    public String getPath() {
        return this.myFile.getPath();
    }

    @Override
    public VirtualFileSystem getFileSystem() {
        return this.myFile.getFileSystem();
    }

    @Override
    public boolean isValid() {
        return this.myFile.isValid();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VFilePropertyChangeEvent event = (VFilePropertyChangeEvent)o;
        if (!this.myFile.equals(event.myFile)) {
            return false;
        }
        if (this.myNewValue != null ? !this.myNewValue.equals(event.myNewValue) : event.myNewValue != null) {
            return false;
        }
        if (this.myOldValue != null ? !this.myOldValue.equals(event.myOldValue) : event.myOldValue != null) {
            return false;
        }
        return this.myPropertyName.equals(event.myPropertyName);
    }

    @Override
    public int hashCode() {
        int result = this.myFile.hashCode();
        result = 31 * result + this.myPropertyName.hashCode();
        result = 31 * result + (this.myOldValue != null ? this.myOldValue.hashCode() : 0);
        result = 31 * result + (this.myNewValue != null ? this.myNewValue.hashCode() : 0);
        return result;
    }

    @NonNls
    public String toString() {
        return "VfsEvent[property(" + this.myPropertyName + ") changed for '" + this.myFile + "':" + " oldValue = " + this.myOldValue + ", newValue = " + this.myNewValue + "]";
    }

    public String getOldPath() {
        String newName;
        int i;
        String path = this.getPath();
        if ("name".equals(this.myPropertyName) && this.myNewValue instanceof String && this.myOldValue instanceof String && (i = path.lastIndexOf(newName = (String)this.myNewValue)) != -1) {
            path = new StringBuilder(path).replace(i, i + newName.length(), (String)this.myOldValue).toString();
        }
        return path;
    }
}

