/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.ExpirableRunnable;
import com.intellij.openapi.wm.FocusRequestor;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.PassThroughIdeFocusManager;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;

public abstract class IdeFocusManager
implements FocusRequestor {
    public abstract JComponent getFocusTargetFor(JComponent var1);

    public abstract void doWhenFocusSettlesDown(Runnable var1);

    public abstract void doWhenFocusSettlesDown(ExpirableRunnable var1);

    public abstract Component getFocusedDescendantFor(Component var1);

    public abstract boolean dispatch(KeyEvent var1);

    public abstract void typeAheadUntil(ActionCallback var1);

    public abstract boolean isFocusBeingTransferred();

    public abstract ActionCallback requestDefaultFocus(boolean var1);

    public abstract boolean isFocusTransferEnabled();

    public abstract Expirable getTimestamp(boolean var1);

    public abstract FocusRequestor getFurtherRequestor();

    public abstract void revalidateFocus(ExpirableRunnable var1);

    public abstract void setTypeaheadEnabled(boolean var1);

    public abstract Component getFocusOwner();

    public abstract void runOnOwnContext(DataContext var1, Runnable var2);

    public abstract Component getLastFocusedFor(IdeFrame var1);

    public abstract IdeFrame getLastFocusedFrame();

    public abstract void toFront(JComponent var1);

    public static IdeFocusManager getInstance(Project project) {
        if (project == null || project.isDisposed() || !project.isInitialized()) {
            return IdeFocusManager.getGlobalInstance();
        }
        return project.getComponent(IdeFocusManager.class);
    }

    public static IdeFocusManager findInstanceByContext(DataContext context) {
        IdeFocusManager instance = null;
        if (context != null) {
            instance = IdeFocusManager.getInstanceSafe(CommonDataKeys.PROJECT.getData(context));
        }
        if (instance == null) {
            instance = IdeFocusManager.findByComponent(KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow());
        }
        if (instance == null) {
            instance = IdeFocusManager.getGlobalInstance();
        }
        return instance;
    }

    public static IdeFocusManager findInstanceByComponent(Component c) {
        IdeFocusManager instance = IdeFocusManager.findByComponent(c);
        return instance != null ? instance : IdeFocusManager.findInstanceByContext(null);
    }

    private static IdeFocusManager findByComponent(Component c) {
        Component parent = UIUtil.findUltimateParent((Component)c);
        if (parent instanceof IdeFrame) {
            return IdeFocusManager.getInstanceSafe(((IdeFrame)((Object)parent)).getProject());
        }
        return null;
    }

    private static IdeFocusManager getInstanceSafe(Project project) {
        if (project != null && !project.isDisposed() && project.isInitialized()) {
            return IdeFocusManager.getInstance(project);
        }
        return null;
    }

    public static IdeFocusManager findInstance() {
        Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        return owner != null ? IdeFocusManager.findInstanceByComponent(owner) : IdeFocusManager.findInstanceByContext(null);
    }

    public static IdeFocusManager getGlobalInstance() {
        IdeFocusManager fm = null;
        Application app = ApplicationManager.getApplication();
        if (app != null && app.hasComponent(IdeFocusManager.class)) {
            fm = app.getComponent(IdeFocusManager.class);
        }
        if (fm == null) {
            fm = PassThroughIdeFocusManager.getInstance();
        }
        return fm;
    }
}

