/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.ExpirableRunnable;
import com.intellij.openapi.wm.FocusCommand;
import com.intellij.openapi.wm.FocusRequestor;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class PassThroughIdeFocusManager
extends IdeFocusManager {
    private static final PassThroughIdeFocusManager ourInstance = new PassThroughIdeFocusManager();

    public static PassThroughIdeFocusManager getInstance() {
        return ourInstance;
    }

    @Override
    public ActionCallback requestFocus(Component c, boolean forced) {
        c.requestFocus();
        return new ActionCallback.Done();
    }

    @Override
    public ActionCallback requestFocus(FocusCommand command, boolean forced) {
        return command.run();
    }

    @Override
    public JComponent getFocusTargetFor(JComponent comp) {
        return comp;
    }

    @Override
    public void doWhenFocusSettlesDown(Runnable runnable) {
        runnable.run();
    }

    @Override
    public void doWhenFocusSettlesDown(ExpirableRunnable runnable) {
        if (!runnable.isExpired()) {
            runnable.run();
        }
    }

    @Override
    public Component getFocusedDescendantFor(Component comp) {
        Component focused = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focused == null) {
            return null;
        }
        if (focused == comp || SwingUtilities.isDescendingFrom(focused, comp)) {
            return focused;
        }
        return null;
    }

    @Override
    public boolean dispatch(KeyEvent e) {
        return false;
    }

    @Override
    public void typeAheadUntil(ActionCallback done) {
    }

    @Override
    public ActionCallback requestDefaultFocus(boolean forced) {
        return new ActionCallback.Done();
    }

    @Override
    public boolean isFocusTransferEnabled() {
        return true;
    }

    @Override
    public Expirable getTimestamp(boolean trackOnlyForcedCommands) {
        return new Expirable(){

            @Override
            public boolean isExpired() {
                return false;
            }
        };
    }

    @Override
    public FocusRequestor getFurtherRequestor() {
        return this;
    }

    @Override
    public void revalidateFocus(ExpirableRunnable runnable) {
    }

    @Override
    public void setTypeaheadEnabled(boolean enabled) {
    }

    @Override
    public Component getFocusOwner() {
        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
    }

    @Override
    public void runOnOwnContext(DataContext context, Runnable runnable) {
        runnable.run();
    }

    @Override
    public Component getLastFocusedFor(IdeFrame frame) {
        return null;
    }

    @Override
    public IdeFrame getLastFocusedFrame() {
        return null;
    }

    @Override
    public void toFront(JComponent c) {
    }

    @Override
    public boolean isFocusBeingTransferred() {
        return false;
    }

    public void dispose() {
    }
}

