/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBarInfo;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;

public interface StatusBar
extends StatusBarInfo,
Disposable {
    public void addWidget(StatusBarWidget var1);

    public void addWidget(StatusBarWidget var1, String var2);

    public void addWidget(StatusBarWidget var1, Disposable var2);

    public void addWidget(StatusBarWidget var1, String var2, Disposable var3);

    @Deprecated
    public void addCustomIndicationComponent(JComponent var1);

    @Deprecated
    public void removeCustomIndicationComponent(JComponent var1);

    public void removeWidget(String var1);

    public void updateWidget(String var1);

    public StatusBarWidget getWidget(String var1);

    public void fireNotificationPopup(JComponent var1, Color var2);

    public StatusBar createChild();

    public JComponent getComponent();

    public StatusBar findChild(Component var1);

    public IdeFrame getFrame();

    public void install(IdeFrame var1);

    public static abstract class Info
    implements StatusBarInfo {
        public static final Topic<StatusBarInfo> TOPIC = Topic.create((String)"IdeStatusBar.Text", StatusBarInfo.class);

        private Info() {
        }

        public static void set(String text, Project project) {
            Info.set(text, project, null);
        }

        public static void set(final String text, final Project project, final String requestor) {
            if (project != null) {
                if (project.isDisposed()) {
                    return;
                }
                if (!project.isInitialized()) {
                    StartupManager.getInstance(project).runWhenProjectIsInitialized(new Runnable(){

                        @Override
                        public void run() {
                            ((StatusBarInfo)project.getMessageBus().syncPublisher(TOPIC)).setInfo(text, requestor);
                        }
                    });
                    return;
                }
            }
            MessageBus bus = project == null ? ApplicationManager.getApplication().getMessageBus() : project.getMessageBus();
            ((StatusBarInfo)bus.syncPublisher(TOPIC)).setInfo(text, requestor);
        }
    }
}

