/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.TreeElementPattern;
import com.intellij.util.ProcessingContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.reflect.AbstractDomChildrenDescription;
import com.intellij.util.xml.reflect.DomChildrenDescription;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;

public class DomElementPattern<T extends DomElement, Self extends DomElementPattern<T, Self>>
extends TreeElementPattern<DomElement, T, Self> {
    protected DomElementPattern(Class<T> aClass) {
        super(aClass);
    }

    protected DomElementPattern(InitialPatternCondition<T> condition) {
        super(condition);
    }

    @Override
    protected DomElement getParent(DomElement t) {
        return t.getParent();
    }

    protected DomElement[] getChildren(DomElement domElement) {
        final ArrayList children = new ArrayList();
        domElement.acceptChildren(new DomElementVisitor(){

            @Override
            public void visitDomElement(DomElement element) {
                children.add(element);
            }
        });
        return children.toArray(new DomElement[children.size()]);
    }

    public Self withChild(final @NonNls String localName, final ElementPattern pattern) {
        return (Self)((DomElementPattern)this.with(new PatternCondition<T>("withChild"){

            @Override
            public boolean accepts(T t, ProcessingContext context) {
                for (AbstractDomChildrenDescription abstractDomChildrenDescription : t.getGenericInfo().getChildrenDescriptions()) {
                    if (abstractDomChildrenDescription instanceof DomChildrenDescription && !localName.equals(((DomChildrenDescription)abstractDomChildrenDescription).getXmlElementName())) continue;
                    for (DomElement domElement : abstractDomChildrenDescription.getValues((DomElement)t)) {
                        if (!localName.equals(domElement.getXmlElementName()) || !pattern.accepts(domElement, context)) continue;
                        return true;
                    }
                }
                return false;
            }
        }));
    }

    public static class Capture<T extends DomElement>
    extends DomElementPattern<T, Capture<T>> {
        protected Capture(Class<T> aClass) {
            super(aClass);
        }
    }
}

