/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PatternConditionPlus;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiNamePatternCondition;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.TreeElementPattern;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.TokenType;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NonNls;

public abstract class PsiElementPattern<T extends PsiElement, Self extends PsiElementPattern<T, Self>>
extends TreeElementPattern<PsiElement, T, Self> {
    protected PsiElementPattern(Class<T> aClass) {
        super(aClass);
    }

    protected PsiElementPattern(InitialPatternCondition<T> condition) {
        super(condition);
    }

    protected PsiElement[] getChildren(PsiElement element) {
        return element.getChildren();
    }

    @Override
    protected PsiElement getParent(PsiElement element) {
        return element.getContext();
    }

    public Self withElementType(IElementType type) {
        return this.withElementType((ElementPattern<IElementType>)PlatformPatterns.elementType().equalTo(type));
    }

    public Self withElementType(TokenSet type) {
        return this.withElementType(PlatformPatterns.elementType().tokenSet(type));
    }

    public Self afterLeaf(String ... withText) {
        return this.afterLeaf((ElementPattern<? extends PsiElement>)PlatformPatterns.psiElement().withText(StandardPatterns.string().oneOf(withText)));
    }

    public Self afterLeaf(ElementPattern<? extends PsiElement> pattern) {
        return this.afterLeafSkipping((ElementPattern)PlatformPatterns.psiElement().whitespaceCommentEmptyOrError(), pattern);
    }

    public Self beforeLeaf(ElementPattern<? extends PsiElement> pattern) {
        return this.beforeLeafSkipping((ElementPattern)PlatformPatterns.psiElement().whitespaceCommentEmptyOrError(), pattern);
    }

    public Self whitespace() {
        return this.withElementType(TokenType.WHITE_SPACE);
    }

    public Self whitespaceCommentOrError() {
        return (Self)((PsiElementPattern)this.andOr(new ElementPattern[]{PlatformPatterns.psiElement().whitespace(), PlatformPatterns.psiElement(PsiComment.class), PlatformPatterns.psiElement(PsiErrorElement.class)}));
    }

    public Self whitespaceCommentEmptyOrError() {
        return (Self)((PsiElementPattern)this.andOr(new ElementPattern[]{PlatformPatterns.psiElement().whitespace(), PlatformPatterns.psiElement(PsiComment.class), PlatformPatterns.psiElement(PsiErrorElement.class), PlatformPatterns.psiElement().withText("")}));
    }

    public Self withFirstNonWhitespaceChild(ElementPattern<? extends PsiElement> pattern) {
        return (Self)((PsiElementPattern)this.withChildren(StandardPatterns.collection(PsiElement.class).filter(StandardPatterns.not(PlatformPatterns.psiElement().whitespace()), StandardPatterns.collection(PsiElement.class).first(pattern))));
    }

    public Self withReference(final Class<? extends PsiReference> referenceClass) {
        return (Self)((PsiElementPattern)this.with(new PatternCondition<T>("withReference"){

            @Override
            public boolean accepts(T t, ProcessingContext context) {
                for (PsiReference reference : t.getReferences()) {
                    if (!referenceClass.isInstance(reference)) continue;
                    return true;
                }
                return false;
            }
        }));
    }

    public Self inFile(final ElementPattern<? extends PsiFile> filePattern) {
        return (Self)((PsiElementPattern)this.with(new PatternCondition<T>("inFile"){

            @Override
            public boolean accepts(T t, ProcessingContext context) {
                return filePattern.accepts(t.getContainingFile(), context);
            }
        }));
    }

    public Self inVirtualFile(final ElementPattern<? extends VirtualFile> filePattern) {
        return (Self)((PsiElementPattern)this.with(new PatternCondition<T>("inVirtualFile"){

            @Override
            public boolean accepts(T t, ProcessingContext context) {
                return filePattern.accepts(t.getContainingFile().getViewProvider().getVirtualFile(), context);
            }
        }));
    }

    @Override
    public Self equalTo(T o) {
        return (Self)((PsiElementPattern)this.with(new PatternCondition<T>("equalTo", (PsiElement)o){
            final /* synthetic */ PsiElement val$o;
            {
                this.val$o = psiElement;
                super(x0);
            }

            @Override
            public boolean accepts(T t, ProcessingContext context) {
                return t.getManager().areElementsEquivalent((PsiElement)t, this.val$o);
            }
        }));
    }

    public Self withElementType(final ElementPattern<IElementType> pattern) {
        return (Self)((PsiElementPattern)this.with(new PatternCondition<T>("withElementType"){

            @Override
            public boolean accepts(T t, ProcessingContext context) {
                ASTNode node = t.getNode();
                return node != null && pattern.accepts(node.getElementType());
            }
        }));
    }

    public Self withText(@NonNls String text) {
        return this.withText((ElementPattern)StandardPatterns.string().equalTo(text));
    }

    public Self withoutText(String text) {
        return this.withoutText((ElementPattern)StandardPatterns.string().equalTo(text));
    }

    public Self withName(@NonNls String name) {
        return this.withName((ElementPattern<String>)StandardPatterns.string().equalTo(name));
    }

    public Self withName(String ... names) {
        return this.withName(StandardPatterns.string().oneOf(names));
    }

    public Self withName(ElementPattern<String> name) {
        return (Self)((PsiElementPattern)this.with(new PsiNamePatternCondition("withName", name)));
    }

    public Self afterLeafSkipping(final ElementPattern skip, final ElementPattern pattern) {
        return (Self)((PsiElementPattern)this.with(new PatternCondition<T>("afterLeafSkipping"){

            @Override
            public boolean accepts(T t, ProcessingContext context) {
                Object element = t;
                while ((element = PsiTreeUtil.prevLeaf(element)) != null && element.getTextLength() == 0 || skip.accepts(element, context)) {
                }
                return pattern.accepts(element, context);
            }
        }));
    }

    public Self beforeLeafSkipping(final ElementPattern skip, final ElementPattern pattern) {
        return (Self)((PsiElementPattern)this.with(new PatternCondition<T>("beforeLeafSkipping"){

            @Override
            public boolean accepts(T t, ProcessingContext context) {
                Object element = t;
                while ((element = PsiTreeUtil.nextLeaf(element)) != null && element.getTextLength() == 0 || skip.accepts(element, context)) {
                }
                return pattern.accepts(element, context);
            }
        }));
    }

    public Self atStartOf(final ElementPattern pattern) {
        return (Self)((PsiElementPattern)this.with(new PatternCondition<T>("atStartOf"){

            @Override
            public boolean accepts(T t, ProcessingContext context) {
                for (Object element = t; element != null; element = element.getContext()) {
                    if (!pattern.accepts(element, context)) continue;
                    return element.getTextRange().getStartOffset() == t.getTextRange().getStartOffset();
                }
                return false;
            }
        }));
    }

    public Self withTextLength(ElementPattern lengthPattern) {
        return (Self)((PsiElementPattern)this.with(new PatternConditionPlus<T, Integer>("withTextLength", lengthPattern){

            @Override
            public boolean processValues(T t, ProcessingContext context, PairProcessor<Integer, ProcessingContext> integerProcessingContextPairProcessor) {
                return integerProcessingContextPairProcessor.process((Object)t.getTextLength(), (Object)context);
            }
        }));
    }

    public Self notEmpty() {
        return this.withTextLengthLongerThan(0);
    }

    public Self withTextLengthLongerThan(final int minLength) {
        return (Self)((PsiElementPattern)this.with(new PatternCondition<T>("withTextLengthLongerThan"){

            @Override
            public boolean accepts(T t, ProcessingContext context) {
                return t.getTextLength() > minLength;
            }
        }));
    }

    public Self withText(ElementPattern text) {
        return (Self)((PsiElementPattern)this.with(this._withText(text)));
    }

    private PatternCondition<T> _withText(ElementPattern pattern) {
        return new PatternConditionPlus<T, String>("_withText", pattern){

            @Override
            public boolean processValues(T t, ProcessingContext context, PairProcessor<String, ProcessingContext> processor) {
                return processor.process((Object)t.getText(), (Object)context);
            }
        };
    }

    public Self withoutText(ElementPattern text) {
        return (Self)((PsiElementPattern)this.without(this._withText(text)));
    }

    public Self withLanguage(final Language language) {
        return (Self)((PsiElementPattern)this.with(new PatternCondition<T>("withLanguage"){

            @Override
            public boolean accepts(T t, ProcessingContext context) {
                return ((Object)((Object)t.getLanguage())).equals((Object)language);
            }
        }));
    }

    public Self withMetaData(final ElementPattern<? extends PsiMetaData> metaDataPattern) {
        return (Self)((PsiElementPattern)this.with(new PatternCondition<T>("withMetaData"){

            @Override
            public boolean accepts(T t, ProcessingContext context) {
                return t instanceof PsiMetaOwner && metaDataPattern.accepts(((PsiMetaOwner)t).getMetaData(), context);
            }
        }));
    }

    public Self referencing(final ElementPattern<? extends PsiElement> targetPattern) {
        return (Self)((PsiElementPattern)this.with(new PatternCondition<T>("referencing"){

            @Override
            public boolean accepts(T t, ProcessingContext context) {
                PsiReference[] references;
                for (PsiReference reference : references = t.getReferences()) {
                    if (targetPattern.accepts(reference.resolve(), context)) {
                        return true;
                    }
                    if (!(reference instanceof PsiPolyVariantReference)) continue;
                    for (ResolveResult result : ((PsiPolyVariantReference)reference).multiResolve(true)) {
                        if (!targetPattern.accepts(result.getElement(), context)) continue;
                        return true;
                    }
                }
                return false;
            }
        }));
    }

    public Self compiled() {
        return (Self)((PsiElementPattern)this.with(new PatternCondition<T>("compiled"){

            @Override
            public boolean accepts(T t, ProcessingContext context) {
                return t instanceof PsiCompiledElement;
            }
        }));
    }

    public Self withTreeParent(final ElementPattern<? extends PsiElement> ancestor) {
        return (Self)((PsiElementPattern)this.with(new PatternCondition<T>("withTreeParent"){

            @Override
            public boolean accepts(T t, ProcessingContext context) {
                return ancestor.accepts(t.getParent(), context);
            }
        }));
    }

    public Self insideStarting(final ElementPattern<? extends PsiElement> ancestor) {
        return (Self)((PsiElementPattern)this.with(new PatternCondition<PsiElement>("insideStarting"){

            @Override
            public boolean accepts(PsiElement start, ProcessingContext context) {
                PsiElement element = PsiElementPattern.this.getParent(start);
                TextRange range = start.getTextRange();
                if (range == null) {
                    return false;
                }
                int startOffset = range.getStartOffset();
                while (element != null && element.getTextRange() != null && element.getTextRange().getStartOffset() == startOffset) {
                    if (ancestor.accepts(element, context)) {
                        return true;
                    }
                    element = PsiElementPattern.this.getParent(element);
                }
                return false;
            }
        }));
    }

    public static class Capture<T extends PsiElement>
    extends PsiElementPattern<T, Capture<T>> {
        protected Capture(Class<T> aClass) {
            super(aClass);
        }

        protected Capture(InitialPatternCondition<T> condition) {
            super(condition);
        }
    }
}

