/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.IElementTypePattern;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.InitialPatternConditionPlus;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiAnnotationPattern;
import com.intellij.patterns.PsiBinaryExpressionPattern;
import com.intellij.patterns.PsiClassPattern;
import com.intellij.patterns.PsiExpressionPattern;
import com.intellij.patterns.PsiFieldPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiMemberPattern;
import com.intellij.patterns.PsiMethodPattern;
import com.intellij.patterns.PsiModifierListOwnerPattern;
import com.intellij.patterns.PsiNameValuePairPattern;
import com.intellij.patterns.PsiParameterPattern;
import com.intellij.patterns.PsiStatementPattern;
import com.intellij.patterns.PsiTypeCastExpressionPattern;
import com.intellij.patterns.PsiTypePattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.VirtualFilePattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ProcessingContext;
import java.util.Collections;
import java.util.List;

public class PsiJavaPatterns
extends StandardPatterns {
    public static IElementTypePattern elementType() {
        return PlatformPatterns.elementType();
    }

    public static VirtualFilePattern virtualFile() {
        return PlatformPatterns.virtualFile();
    }

    public static PsiJavaElementPattern.Capture<PsiElement> psiElement() {
        return new PsiJavaElementPattern.Capture<PsiElement>(PsiElement.class);
    }

    public static PsiJavaElementPattern.Capture<PsiElement> psiElement(IElementType type) {
        return (PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withElementType(type);
    }

    public static <T extends PsiElement> PsiJavaElementPattern.Capture<T> psiElement(Class<T> aClass) {
        return new PsiJavaElementPattern.Capture<T>(aClass);
    }

    public static PsiJavaElementPattern.Capture<PsiElement> psiElement(final Class<? extends PsiElement> ... classAlternatives) {
        return new PsiJavaElementPattern.Capture<PsiElement>(new InitialPatternCondition<PsiElement>(PsiElement.class){

            @Override
            public boolean accepts(Object o, ProcessingContext context) {
                for (Class classAlternative : classAlternatives) {
                    if (!classAlternative.isInstance(o)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    public static PsiJavaElementPattern.Capture<PsiLiteralExpression> literalExpression() {
        return PsiJavaPatterns.literalExpression(null);
    }

    public static PsiJavaElementPattern.Capture<PsiLiteral> psiLiteral() {
        return PsiJavaPatterns.psiLiteral(null);
    }

    public static PsiJavaElementPattern.Capture<PsiLiteral> psiLiteral(final ElementPattern value) {
        return new PsiJavaElementPattern.Capture<PsiLiteral>(new InitialPatternConditionPlus<PsiLiteral>(PsiLiteral.class){

            @Override
            public boolean accepts(Object o, ProcessingContext context) {
                return o instanceof PsiLiteral && (value == null || value.accepts(((PsiLiteral)o).getValue(), context));
            }

            @Override
            public List<ElementPattern<?>> getPatterns() {
                return Collections.singletonList(value);
            }
        });
    }

    public static PsiJavaElementPattern.Capture<PsiNewExpression> psiNewExpression(final String ... fqns) {
        return new PsiJavaElementPattern.Capture<PsiNewExpression>(new InitialPatternCondition<PsiNewExpression>(PsiNewExpression.class){

            @Override
            public boolean accepts(Object o, ProcessingContext context) {
                PsiJavaCodeReferenceElement reference;
                if (o instanceof PsiNewExpression && (reference = ((PsiNewExpression)o).getClassOrAnonymousClassReference()) != null) {
                    for (String fqn : fqns) {
                        if (!fqn.equals(reference.getQualifiedName())) continue;
                        return true;
                    }
                }
                return false;
            }
        });
    }

    public static PsiJavaElementPattern.Capture<PsiLiteralExpression> literalExpression(final ElementPattern value) {
        return new PsiJavaElementPattern.Capture<PsiLiteralExpression>(new InitialPatternConditionPlus<PsiLiteralExpression>(PsiLiteralExpression.class){

            @Override
            public boolean accepts(Object o, ProcessingContext context) {
                return o instanceof PsiLiteralExpression && (value == null || value.accepts(((PsiLiteralExpression)o).getValue(), context));
            }

            @Override
            public List<ElementPattern<?>> getPatterns() {
                return Collections.singletonList(value);
            }
        });
    }

    public static PsiMemberPattern.Capture psiMember() {
        return new PsiMemberPattern.Capture();
    }

    public static PsiMethodPattern psiMethod() {
        return new PsiMethodPattern();
    }

    public static PsiParameterPattern psiParameter() {
        return new PsiParameterPattern();
    }

    public static PsiModifierListOwnerPattern.Capture<PsiModifierListOwner> psiModifierListOwner() {
        return new PsiModifierListOwnerPattern.Capture<PsiModifierListOwner>(new InitialPatternCondition<PsiModifierListOwner>(PsiModifierListOwner.class){

            @Override
            public boolean accepts(Object o, ProcessingContext context) {
                return o instanceof PsiModifierListOwner;
            }
        });
    }

    public static PsiFieldPattern psiField() {
        return new PsiFieldPattern();
    }

    public static PsiClassPattern psiClass() {
        return new PsiClassPattern();
    }

    public static PsiAnnotationPattern psiAnnotation() {
        return new PsiAnnotationPattern();
    }

    public static PsiNameValuePairPattern psiNameValuePair() {
        return new PsiNameValuePairPattern();
    }

    public static PsiTypePattern psiType() {
        return new PsiTypePattern();
    }

    public static PsiExpressionPattern.Capture<PsiExpression> psiExpression() {
        return new PsiExpressionPattern.Capture<PsiExpression>(PsiExpression.class);
    }

    public static PsiBinaryExpressionPattern psiBinaryExpression() {
        return new PsiBinaryExpressionPattern();
    }

    public static PsiTypeCastExpressionPattern psiTypeCastExpression() {
        return new PsiTypeCastExpressionPattern();
    }

    public static PsiJavaElementPattern.Capture<PsiReferenceExpression> psiReferenceExpression() {
        return PsiJavaPatterns.psiElement(PsiReferenceExpression.class);
    }

    public static PsiStatementPattern.Capture<PsiExpressionStatement> psiExpressionStatement() {
        return new PsiStatementPattern.Capture<PsiExpressionStatement>(PsiExpressionStatement.class);
    }

    public static PsiStatementPattern.Capture<PsiReturnStatement> psiReturnStatement() {
        return new PsiStatementPattern.Capture<PsiReturnStatement>(PsiReturnStatement.class);
    }
}

