/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.patterns.CharPattern;
import com.intellij.patterns.CollectionPattern;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ElementPatternCondition;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.InitialPatternConditionPlus;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.StringPattern;
import com.intellij.util.ProcessingContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;

public class StandardPatterns {
    private static final FalsePattern FALSE_PATTERN = new FalsePattern();

    public static StringPattern string() {
        return new StringPattern();
    }

    public static CharPattern character() {
        return new CharPattern();
    }

    public static <T> ObjectPattern.Capture<T> instanceOf(Class<T> aClass) {
        return new ObjectPattern.Capture<T>(aClass);
    }

    public static <T> ElementPattern save(final Key<T> key) {
        return new ObjectPattern.Capture(new InitialPatternCondition(Object.class){

            @Override
            public boolean accepts(Object o, ProcessingContext context) {
                context.put(key, o);
                return true;
            }

            @Override
            public void append(@NonNls StringBuilder builder, String indent) {
                builder.append("save(").append(key).append(")");
            }
        });
    }

    public static ObjectPattern.Capture<Object> object() {
        return StandardPatterns.instanceOf(Object.class);
    }

    public static <T> ObjectPattern.Capture<T> object(T value) {
        return (ObjectPattern.Capture)StandardPatterns.instanceOf(value.getClass()).equalTo(value);
    }

    public static <T> CollectionPattern<T> collection(Class<T> aClass) {
        return new CollectionPattern();
    }

    public static ElementPattern get(final @NonNls String key) {
        return new ObjectPattern.Capture(new InitialPatternCondition(Object.class){

            @Override
            public boolean accepts(Object o, ProcessingContext context) {
                return Comparing.equal((Object)o, (Object)context.get((Object)key));
            }

            @Override
            public void append(@NonNls StringBuilder builder, String indent) {
                builder.append("get(").append(key).append(")");
            }
        });
    }

    public static <T> CollectionPattern<T> collection() {
        return new CollectionPattern();
    }

    public static <E> ElementPattern<E> or(final ElementPattern<? extends E> ... patterns) {
        return new ObjectPattern.Capture(new InitialPatternConditionPlus(Object.class){

            @Override
            public boolean accepts(Object o, ProcessingContext context) {
                for (ElementPattern pattern : patterns) {
                    if (!pattern.accepts(o, context)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void append(@NonNls StringBuilder builder, String indent) {
                boolean first = true;
                for (ElementPattern pattern : patterns) {
                    if (!first) {
                        builder.append("\n").append(indent);
                    }
                    first = false;
                    pattern.getCondition().append(builder, indent + "  ");
                }
            }

            @Override
            public List<ElementPattern<?>> getPatterns() {
                return Arrays.asList(patterns);
            }
        });
    }

    public static <E> ElementPattern<E> and(final ElementPattern<? extends E> ... patterns) {
        return new ObjectPattern.Capture(new InitialPatternConditionPlus(Object.class){

            @Override
            public boolean accepts(Object o, ProcessingContext context) {
                for (ElementPattern pattern : patterns) {
                    if (pattern.accepts(o, context)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public void append(@NonNls StringBuilder builder, String indent) {
                boolean first = true;
                for (ElementPattern pattern : patterns) {
                    if (!first) {
                        builder.append("\n").append(indent);
                    }
                    first = false;
                    pattern.getCondition().append(builder, indent + "  ");
                }
            }

            @Override
            public List<ElementPattern<?>> getPatterns() {
                return Arrays.asList(patterns);
            }
        });
    }

    public static <E> ObjectPattern.Capture<E> not(final ElementPattern<E> pattern) {
        return new ObjectPattern.Capture(new InitialPatternConditionPlus(Object.class){

            @Override
            public boolean accepts(Object o, ProcessingContext context) {
                return !pattern.accepts(o, context);
            }

            @Override
            public void append(@NonNls StringBuilder builder, String indent) {
                pattern.getCondition().append(builder.append("not("), indent + "  ");
                builder.append(")");
            }

            @Override
            public List<ElementPattern<?>> getPatterns() {
                return Collections.singletonList(pattern);
            }
        });
    }

    public static <T> ObjectPattern.Capture<T> optional(final ElementPattern<T> pattern) {
        return new ObjectPattern.Capture(new InitialPatternCondition(Object.class){

            @Override
            public boolean accepts(Object o, ProcessingContext context) {
                pattern.accepts(o, context);
                return true;
            }
        });
    }

    public static <E> ElementPattern<E> alwaysFalse() {
        return FALSE_PATTERN;
    }

    private static final class FalsePattern
    implements ElementPattern {
        private FalsePattern() {
        }

        @Override
        public boolean accepts(Object o) {
            return false;
        }

        @Override
        public boolean accepts(Object o, ProcessingContext context) {
            return false;
        }

        public ElementPatternCondition getCondition() {
            return new ElementPatternCondition(new InitialPatternCondition(Object.class){

                @Override
                public boolean accepts(Object o, ProcessingContext context) {
                    return false;
                }
            });
        }
    }
}

