/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.CaseInsensitiveValuePatternCondition;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.ValuePatternCondition;
import com.intellij.util.ProcessingContext;
import dk.brics.automaton.Automaton;
import dk.brics.automaton.AutomatonProvider;
import dk.brics.automaton.DatatypesAutomatonProvider;
import dk.brics.automaton.RegExp;
import dk.brics.automaton.RunAutomaton;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;

public class StringPattern
extends ObjectPattern<String, StringPattern> {
    private static final InitialPatternCondition<String> CONDITION = new InitialPatternCondition<String>(String.class){

        @Override
        public boolean accepts(Object o, ProcessingContext context) {
            return o instanceof String;
        }

        @Override
        public void append(@NonNls StringBuilder builder, String indent) {
            builder.append("string()");
        }
    };

    protected StringPattern() {
        super(CONDITION);
    }

    public StringPattern startsWith(final @NonNls String s) {
        return (StringPattern)this.with(new PatternCondition<String>("startsWith"){

            @Override
            public boolean accepts(String str, ProcessingContext context) {
                return StringUtil.startsWith((CharSequence)str, (CharSequence)s);
            }
        });
    }

    public StringPattern endsWith(final @NonNls String s) {
        return (StringPattern)this.with(new PatternCondition<String>("endsWith"){

            @Override
            public boolean accepts(String str, ProcessingContext context) {
                return StringUtil.endsWith((CharSequence)str, (CharSequence)s);
            }
        });
    }

    public StringPattern contains(final @NonNls String s) {
        return (StringPattern)this.with(new PatternCondition<String>("contains"){

            @Override
            public boolean accepts(String str, ProcessingContext context) {
                return StringUtil.contains((CharSequence)str, (CharSequence)s);
            }
        });
    }

    public StringPattern containsChars(final @NonNls String s) {
        return (StringPattern)this.with(new PatternCondition<String>("containsChars"){

            @Override
            public boolean accepts(String str, ProcessingContext context) {
                return StringUtil.containsAnyChar((String)str, (String)s);
            }
        });
    }

    public StringPattern matches(final @NonNls String s) {
        String escaped = StringUtil.escapeToRegexp((String)s);
        if (escaped.equals(s)) {
            return (StringPattern)this.equalTo(s);
        }
        final Pattern pattern = Pattern.compile(s);
        return (StringPattern)this.with(new ValuePatternCondition<String>("matches"){

            @Override
            public boolean accepts(String str, ProcessingContext context) {
                return pattern.matcher(StringPattern.newBombedCharSequence(str)).matches();
            }

            @Override
            public Collection<String> getValues() {
                return Collections.singleton(s);
            }
        });
    }

    public StringPattern matchesBrics(final @NonNls String s) {
        String escaped = StringUtil.escapeToRegexp((String)s);
        if (escaped.equals(s)) {
            return (StringPattern)this.equalTo(s);
        }
        StringBuilder sb = new StringBuilder(s.length() * 5);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == ' ') {
                sb.append("<whitespacechar>");
                continue;
            }
            if (Character.isUpperCase(c)) {
                sb.append('[').append(Character.toUpperCase(c)).append(Character.toLowerCase(c)).append(']');
                continue;
            }
            sb.append(c);
        }
        RegExp regExp = new RegExp(sb.toString());
        Automaton automaton = regExp.toAutomaton((AutomatonProvider)new DatatypesAutomatonProvider());
        final RunAutomaton runAutomaton = new RunAutomaton(automaton, true);
        return (StringPattern)this.with(new ValuePatternCondition<String>("matchesBrics"){

            @Override
            public boolean accepts(String str, ProcessingContext context) {
                if (!(str.isEmpty() || str.charAt(0) != '\"' && str.charAt(0) != '\'')) {
                    str = str.substring(1);
                }
                return runAutomaton.run(str);
            }

            @Override
            public Collection<String> getValues() {
                return Collections.singleton(s);
            }
        });
    }

    public StringPattern contains(final @NonNls ElementPattern<Character> pattern) {
        return (StringPattern)this.with(new PatternCondition<String>("contains"){

            @Override
            public boolean accepts(String str, ProcessingContext context) {
                for (int i = 0; i < str.length(); ++i) {
                    if (!pattern.accepts(Character.valueOf(str.charAt(i)))) continue;
                    return true;
                }
                return false;
            }
        });
    }

    public StringPattern longerThan(final int minLength) {
        return (StringPattern)this.with(new PatternCondition<String>("longerThan"){

            @Override
            public boolean accepts(String s, ProcessingContext context) {
                return s.length() > minLength;
            }
        });
    }

    public StringPattern shorterThan(final int maxLength) {
        return (StringPattern)this.with(new PatternCondition<String>("shorterThan"){

            @Override
            public boolean accepts(String s, ProcessingContext context) {
                return s.length() < maxLength;
            }
        });
    }

    public StringPattern withLength(final int length) {
        return (StringPattern)this.with(new PatternCondition<String>("withLength"){

            @Override
            public boolean accepts(String s, ProcessingContext context) {
                return s.length() == length;
            }
        });
    }

    public StringPattern oneOf(String ... values) {
        return (StringPattern)super.oneOf(values);
    }

    public StringPattern oneOfIgnoreCase(String ... values) {
        return (StringPattern)this.with(new CaseInsensitiveValuePatternCondition("oneOfIgnoreCase", values));
    }

    @Override
    public StringPattern oneOf(@NonNls Collection<String> set) {
        return (StringPattern)super.oneOf(set);
    }

    public static CharSequence newBombedCharSequence(CharSequence sequence) {
        return new StringUtil.BombedCharSequence(sequence){

            protected void checkCanceled() {
                ProgressManager.checkCanceled();
            }
        };
    }
}

