/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PatternConditionPlus;
import com.intellij.patterns.StandardPatterns;
import com.intellij.util.PairProcessor;
import com.intellij.util.ProcessingContext;
import java.util.Arrays;
import java.util.Collection;

public abstract class TreeElementPattern<ParentType, T extends ParentType, Self extends TreeElementPattern<ParentType, T, Self>>
extends ObjectPattern<T, Self> {
    protected TreeElementPattern(InitialPatternCondition<T> condition) {
        super(condition);
    }

    protected TreeElementPattern(Class<T> aClass) {
        super(aClass);
    }

    protected abstract ParentType getParent(ParentType var1);

    protected abstract ParentType[] getChildren(ParentType var1);

    public Self withParents(final Class<? extends ParentType> ... types) {
        return (Self)((TreeElementPattern)this.with(new PatternCondition<T>("withParents"){

            @Override
            public boolean accepts(T t, ProcessingContext context) {
                Object current = TreeElementPattern.this.getParent(t);
                for (Class type : types) {
                    if (current == null || !type.isInstance(current)) {
                        return false;
                    }
                    current = TreeElementPattern.this.getParent(current);
                }
                return true;
            }
        }));
    }

    public Self withParent(Class<? extends ParentType> type) {
        return this.withParent(StandardPatterns.instanceOf(type));
    }

    public Self withParent(ElementPattern<? extends ParentType> pattern) {
        return this.withSuperParent(1, pattern);
    }

    public Self withChild(ElementPattern<? extends ParentType> pattern) {
        return this.withChildren(StandardPatterns.collection().atLeastOne(pattern));
    }

    public Self withFirstChild(ElementPattern<? extends ParentType> pattern) {
        return this.withChildren(StandardPatterns.collection().first(pattern));
    }

    public Self withLastChild(ElementPattern<? extends ParentType> pattern) {
        return this.withChildren(StandardPatterns.collection().last(pattern));
    }

    public Self withChildren(ElementPattern<Collection<ParentType>> pattern) {
        return (Self)((TreeElementPattern)this.with(new PatternConditionPlus<T, Collection<ParentType>>("withChildren", pattern){

            @Override
            public boolean processValues(T t, ProcessingContext context, PairProcessor<Collection<ParentType>, ProcessingContext> processor) {
                return processor.process(Arrays.asList(TreeElementPattern.this.getChildren(t)), (Object)context);
            }
        }));
    }

    public Self isFirstAcceptedChild(final ElementPattern<? super ParentType> pattern) {
        return (Self)((TreeElementPattern)this.with(new PatternCondition<T>("isFirstAcceptedChild"){

            @Override
            public boolean accepts(T t, ProcessingContext context) {
                Object parent = TreeElementPattern.this.getParent(t);
                if (parent != null) {
                    T[] children;
                    for (Object child : children = TreeElementPattern.this.getChildren(parent)) {
                        if (!pattern.accepts(child, context)) continue;
                        return child == t;
                    }
                }
                return false;
            }
        }));
    }

    public Self withSuperParent(int level, Class<? extends ParentType> aClass) {
        return this.withSuperParent(level, StandardPatterns.instanceOf(aClass));
    }

    public Self withSuperParent(final int level, ElementPattern<? extends ParentType> pattern) {
        return (Self)((TreeElementPattern)this.with(new PatternConditionPlus<T, ParentType>(level == 1 ? "withParent" : "withSuperParent", pattern){

            @Override
            public boolean processValues(T t, ProcessingContext context, PairProcessor<ParentType, ProcessingContext> processor) {
                Object parent = t;
                for (int i = 0; i < level; ++i) {
                    if (parent == null) {
                        return true;
                    }
                    parent = TreeElementPattern.this.getParent(parent);
                }
                return processor.process(parent, (Object)context);
            }
        }));
    }

    public Self inside(Class<? extends ParentType> pattern) {
        return this.inside(StandardPatterns.instanceOf(pattern));
    }

    public Self inside(ElementPattern<? extends ParentType> pattern) {
        return this.inside(false, pattern);
    }

    public Self inside(final boolean strict, ElementPattern<? extends ParentType> pattern) {
        return (Self)((TreeElementPattern)this.with(new PatternConditionPlus<T, ParentType>("inside", pattern){

            @Override
            public boolean processValues(T t, ProcessingContext context, PairProcessor<ParentType, ProcessingContext> processor) {
                Object element;
                Object t2 = element = strict ? TreeElementPattern.this.getParent(t) : t;
                while (element != null) {
                    if (!processor.process(element, (Object)context)) {
                        return false;
                    }
                    element = TreeElementPattern.this.getParent(element);
                }
                return true;
            }
        }));
    }

    public Self inside(final boolean strict, final ElementPattern<? extends ParentType> pattern, final ElementPattern<? extends ParentType> stopAt) {
        return (Self)((TreeElementPattern)this.with(new PatternCondition<T>("inside"){

            @Override
            public boolean accepts(T t, ProcessingContext context) {
                Object element;
                Object t2 = element = strict ? TreeElementPattern.this.getParent(t) : t;
                while (element != null) {
                    if (stopAt.accepts(element, context)) {
                        return false;
                    }
                    if (pattern.accepts(element, context)) {
                        return true;
                    }
                    element = TreeElementPattern.this.getParent(element);
                }
                return false;
            }
        }));
    }

    public Self insideSequence(final boolean strict, final ElementPattern<? extends ParentType> ... patterns) {
        return (Self)((TreeElementPattern)this.with(new PatternCondition<T>("insideSequence"){

            @Override
            public boolean accepts(T t, ProcessingContext context) {
                Object element;
                int i = 0;
                Object t2 = element = strict ? TreeElementPattern.this.getParent(t) : t;
                while (element != null && i < patterns.length) {
                    for (int j = i; j < patterns.length; ++j) {
                        if (!patterns[j].accepts(element, context)) continue;
                        if (i != j) {
                            return false;
                        }
                        ++i;
                        break;
                    }
                    element = TreeElementPattern.this.getParent(element);
                }
                return true;
            }
        }));
    }

    public Self afterSibling(final ElementPattern<? extends ParentType> pattern) {
        return (Self)((TreeElementPattern)this.with(new PatternCondition<T>("afterSibling"){

            @Override
            public boolean accepts(T t, ProcessingContext context) {
                Object parent = TreeElementPattern.this.getParent(t);
                if (parent == null) {
                    return false;
                }
                T[] children = TreeElementPattern.this.getChildren(parent);
                int i = Arrays.asList(children).indexOf(t);
                if (i <= 0) {
                    return false;
                }
                return pattern.accepts(children[i - 1], context);
            }
        }));
    }

    public Self afterSiblingSkipping(final ElementPattern skip, final ElementPattern<? extends ParentType> pattern) {
        return (Self)((TreeElementPattern)this.with(new PatternCondition<T>("afterSiblingSkipping"){

            @Override
            public boolean accepts(T t, ProcessingContext context) {
                Object parent = TreeElementPattern.this.getParent(t);
                if (parent == null) {
                    return false;
                }
                T[] children = TreeElementPattern.this.getChildren(parent);
                int i = Arrays.asList(children).indexOf(t);
                while (--i >= 0) {
                    if (skip.accepts(children[i], context)) continue;
                    return pattern.accepts(children[i], context);
                }
                return false;
            }
        }));
    }
}

