/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiFilePattern;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;

public class XmlFilePattern<Self extends XmlFilePattern<Self>>
extends PsiFilePattern<XmlFile, Self> {
    public XmlFilePattern() {
        super(XmlFile.class);
    }

    protected XmlFilePattern(InitialPatternCondition<XmlFile> condition) {
        super(condition);
    }

    public Self withRootTag(final ElementPattern<XmlTag> rootTag) {
        return (Self)((XmlFilePattern)this.with(new PatternCondition<XmlFile>("withRootTag"){

            @Override
            public boolean accepts(XmlFile xmlFile, ProcessingContext context) {
                XmlDocument document = xmlFile.getDocument();
                return document != null && rootTag.accepts(document.getRootTag(), context);
            }
        }));
    }

    public static class Capture
    extends XmlFilePattern<Capture> {
    }
}

