/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pom.impl;

import com.intellij.pom.PomManager;
import com.intellij.pom.PomModelAspect;
import com.intellij.pom.PomTransaction;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;

public abstract class PomTransactionBase
implements PomTransaction {
    private final PsiElement myScope;
    private final PomModelAspect myAspect;
    private final PomModelEvent myAccumulatedEvent;

    public PomTransactionBase(PsiElement scope, PomModelAspect aspect) {
        this.myScope = scope;
        this.myAspect = aspect;
        this.myAccumulatedEvent = new PomModelEvent(PomManager.getModel(scope.getProject()));
    }

    @Override
    public PomModelEvent getAccumulatedEvent() {
        return this.myAccumulatedEvent;
    }

    @Override
    public void run() throws IncorrectOperationException {
        PomModelEvent event = this.runInner();
        if (event == null) {
            this.myAccumulatedEvent.registerChangeSet(this.myAspect, null);
            return;
        }
        this.myAccumulatedEvent.merge(event);
    }

    public abstract PomModelEvent runInner() throws IncorrectOperationException;

    @Override
    public PsiElement getChangeScope() {
        return this.myScope;
    }

    @Override
    public PomModelAspect getTransactionAspect() {
        return this.myAspect;
    }
}

