/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.MainConfigurationStateSplitter;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.profile.ApplicationProfileManager;
import com.intellij.profile.Profile;
import com.intellij.profile.ProfileChangeAdapter;
import com.intellij.profile.ProjectProfileManager;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.OptionTag;
import gnu.trove.THashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public abstract class DefaultProjectProfileManager
extends ProjectProfileManager
implements PersistentStateComponent<Element> {
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.profile.DefaultProjectProfileManager");
    @NonNls
    public static final String SCOPES = "scopes";
    @NonNls
    protected static final String SCOPE = "scope";
    @NonNls
    public static final String PROFILE = "profile";
    @NonNls
    protected static final String NAME = "name";
    private static final String VERSION = "1.0";
    protected final Project myProject;
    protected String myProjectProfile;
    public boolean USE_PROJECT_PROFILE = true;
    private final ApplicationProfileManager myApplicationProfileManager;
    private final Map<String, Profile> myProfiles = new THashMap();
    protected final DependencyValidationManager myHolder;
    private final List<ProfileChangeAdapter> myProfilesListener = ContainerUtil.createLockFreeCopyOnWriteList();
    @NonNls
    private static final String PROJECT_DEFAULT_PROFILE_NAME = "Project Default";

    public DefaultProjectProfileManager(Project project, ApplicationProfileManager applicationProfileManager, DependencyValidationManager holder) {
        this.myProject = project;
        this.myHolder = holder;
        this.myApplicationProfileManager = applicationProfileManager;
    }

    public Project getProject() {
        return this.myProject;
    }

    @Override
    public synchronized Profile getProfile(String name, boolean returnRootProfileIfNamedIsAbsent) {
        return this.myProfiles.containsKey(name) ? this.myProfiles.get(name) : this.myApplicationProfileManager.getProfile(name, returnRootProfileIfNamedIsAbsent);
    }

    @Override
    public synchronized void updateProfile(Profile profile) {
        this.myProfiles.put(profile.getName(), profile);
        for (ProfileChangeAdapter profileChangeAdapter : this.myProfilesListener) {
            profileChangeAdapter.profileChanged(profile);
        }
    }

    @Override
    public synchronized Element getState() {
        Element state = new Element("settings");
        Object[] sortedProfiles = this.myProfiles.keySet().toArray(new String[this.myProfiles.size()]);
        Arrays.sort(sortedProfiles);
        for (Object profile : sortedProfiles) {
            boolean hasSmthToSave;
            Profile projectProfile = this.myProfiles.get(profile);
            if (projectProfile == null) continue;
            Element profileElement = new Element(PROFILE);
            try {
                projectProfile.writeExternal(profileElement);
            }
            catch (WriteExternalException e) {
                LOG.error((Throwable)e);
            }
            boolean bl = hasSmthToSave = sortedProfiles.length > 1 || this.isDefaultProfileUsed();
            if (!hasSmthToSave) {
                for (Element child : profileElement.getChildren()) {
                    if (child.getName().equals("option")) continue;
                    hasSmthToSave = true;
                    break;
                }
            }
            if (!hasSmthToSave) continue;
            state.addContent(profileElement);
        }
        if (!state.getChildren().isEmpty() || this.isDefaultProfileUsed()) {
            XmlSerializer.serializeInto((Object)this, (Element)state);
            state.addContent(new Element("version").setAttribute("value", VERSION));
        }
        return state;
    }

    @Override
    public synchronized void loadState(Element state) {
        this.myProfiles.clear();
        XmlSerializer.deserializeInto((Object)this, (Element)state);
        for (Element o : state.getChildren(PROFILE)) {
            Profile profile = this.myApplicationProfileManager.createProfile();
            profile.setProfileManager(this);
            try {
                profile.readExternal(o);
            }
            catch (InvalidDataException e) {
                LOG.error((Throwable)e);
            }
            profile.setProjectLevel(true);
            this.myProfiles.put(profile.getName(), profile);
        }
        if (state.getChild("version") == null || !Comparing.strEqual((String)state.getChild("version").getAttributeValue("value"), (String)VERSION)) {
            boolean toConvert = true;
            for (Element o : state.getChildren("option")) {
                if (!Comparing.strEqual((String)o.getAttributeValue(NAME), (String)"USE_PROJECT_LEVEL_SETTINGS")) continue;
                toConvert = Boolean.parseBoolean(o.getAttributeValue("value"));
                break;
            }
            if (toConvert) {
                this.convert(state);
            }
        }
    }

    protected void convert(Element element) {
    }

    private boolean isDefaultProfileUsed() {
        return this.myProjectProfile != null && !Comparing.strEqual((String)this.myProjectProfile, (String)PROJECT_DEFAULT_PROFILE_NAME);
    }

    @Override
    public NamedScopesHolder getScopesManager() {
        return this.myHolder;
    }

    @Override
    public synchronized Collection<Profile> getProfiles() {
        this.getProjectProfileImpl();
        return this.myProfiles.values();
    }

    @Override
    public synchronized String[] getAvailableProfileNames() {
        return ArrayUtil.toStringArray(this.myProfiles.keySet());
    }

    @Override
    public synchronized void deleteProfile(String name) {
        this.myProfiles.remove(name);
    }

    @Override
    @OptionTag(value="PROJECT_PROFILE")
    public synchronized String getProjectProfile() {
        return this.myProjectProfile;
    }

    @Override
    public synchronized void setProjectProfile(String newProfile) {
        if (Comparing.strEqual((String)newProfile, (String)this.myProjectProfile)) {
            return;
        }
        String oldProfile = this.myProjectProfile;
        this.myProjectProfile = newProfile;
        boolean bl = this.USE_PROJECT_PROFILE = newProfile != null;
        if (oldProfile != null) {
            for (ProfileChangeAdapter adapter : this.myProfilesListener) {
                adapter.profileActivated(this.getProfile(oldProfile), newProfile != null ? this.getProfile(newProfile) : null);
            }
        }
    }

    public synchronized Profile getProjectProfileImpl() {
        if (!this.USE_PROJECT_PROFILE) {
            return this.myApplicationProfileManager.getRootProfile();
        }
        if (this.myProjectProfile == null || this.myProfiles.isEmpty()) {
            this.setProjectProfile(PROJECT_DEFAULT_PROFILE_NAME);
            Profile projectProfile = this.myApplicationProfileManager.createProfile();
            projectProfile.copyFrom(this.myApplicationProfileManager.getRootProfile());
            projectProfile.setProjectLevel(true);
            projectProfile.setName(PROJECT_DEFAULT_PROFILE_NAME);
            this.myProfiles.put(PROJECT_DEFAULT_PROFILE_NAME, projectProfile);
        } else if (!this.myProfiles.containsKey(this.myProjectProfile)) {
            this.setProjectProfile(this.myProfiles.keySet().iterator().next());
        }
        Profile profile = this.myProfiles.get(this.myProjectProfile);
        profile.setProfileManager(this);
        return profile;
    }

    public void addProfilesListener(final ProfileChangeAdapter profilesListener, Disposable parent) {
        this.myProfilesListener.add(profilesListener);
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                DefaultProjectProfileManager.this.myProfilesListener.remove(profilesListener);
            }
        });
    }

    public void removeProfilesListener(ProfileChangeAdapter profilesListener) {
        this.myProfilesListener.remove(profilesListener);
    }

    protected void fireProfilesInitialized() {
        for (ProfileChangeAdapter profileChangeAdapter : this.myProfilesListener) {
            profileChangeAdapter.profilesInitialized();
        }
    }

    protected void fireProfilesShutdown() {
        for (ProfileChangeAdapter profileChangeAdapter : this.myProfilesListener) {
            profileChangeAdapter.profilesShutdown();
        }
    }

    public static class ProfileStateSplitter
    extends MainConfigurationStateSplitter {
        @Override
        protected String getSubStateFileName(Element element) {
            for (Element option : element.getChildren("option")) {
                if (!option.getAttributeValue(DefaultProjectProfileManager.NAME).equals("myName")) continue;
                return option.getAttributeValue("value");
            }
            throw new IllegalStateException();
        }

        @Override
        protected String getComponentStateFileName() {
            return "profiles_settings";
        }

        @Override
        protected String getSubStateTagName() {
            return DefaultProjectProfileManager.PROFILE;
        }
    }
}

