/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionProvider;
import com.intellij.psi.PsiElement;

public class ElementDescriptionUtil {
    private ElementDescriptionUtil() {
    }

    public static String getElementDescription(PsiElement element, ElementDescriptionLocation location) {
        String result;
        for (ElementDescriptionProvider provider : (ElementDescriptionProvider[])Extensions.getExtensions(ElementDescriptionProvider.EP_NAME)) {
            String result2 = provider.getElementDescription(element, location);
            if (result2 == null) continue;
            return result2;
        }
        ElementDescriptionProvider defaultProvider = location.getDefaultProvider();
        if (defaultProvider != null && (result = defaultProvider.getElementDescription(element, location)) != null) {
            return result;
        }
        return ((Object)element).toString();
    }
}

