/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.search.GlobalSearchScope;

public class PsiArrayType
extends PsiType.Stub {
    private final PsiType myComponentType;

    public PsiArrayType(PsiType componentType) {
        this(componentType, PsiAnnotation.EMPTY_ARRAY);
    }

    public PsiArrayType(PsiType componentType, PsiAnnotation[] annotations) {
        super(annotations);
        this.myComponentType = componentType;
    }

    @Override
    public String getPresentableText() {
        return this.getText(this.myComponentType.getPresentableText(), "[]", false, true);
    }

    @Override
    public String getCanonicalText(boolean annotated) {
        return this.getText(this.myComponentType.getCanonicalText(annotated), "[]", true, annotated);
    }

    @Override
    public String getInternalCanonicalText() {
        return this.getText(this.myComponentType.getInternalCanonicalText(), "[]", true, true);
    }

    protected String getText(String prefix, String suffix, boolean qualified, boolean annotated) {
        PsiAnnotation[] annotations;
        StringBuilder sb = new StringBuilder(prefix.length() + suffix.length());
        sb.append(prefix);
        if (annotated && (annotations = this.getAnnotations()).length != 0) {
            sb.append(' ');
            PsiNameHelper.appendAnnotations(sb, annotations, qualified);
        }
        sb.append(suffix);
        return sb.toString();
    }

    @Override
    public boolean isValid() {
        return this.myComponentType.isValid();
    }

    @Override
    public boolean equalsToText(String text) {
        return text.endsWith("[]") && this.myComponentType.equalsToText(text.substring(0, text.length() - 2));
    }

    @Override
    public <A> A accept(PsiTypeVisitor<A> visitor) {
        return visitor.visitArrayType(this);
    }

    @Override
    public GlobalSearchScope getResolveScope() {
        return this.myComponentType.getResolveScope();
    }

    @Override
    public PsiType[] getSuperTypes() {
        PsiType[] superTypes = this.myComponentType.getSuperTypes();
        PsiType[] result = PsiArrayType.createArray(superTypes.length);
        for (int i = 0; i < superTypes.length; ++i) {
            result[i] = superTypes[i].createArrayType();
        }
        return result;
    }

    public PsiType getComponentType() {
        return this.myComponentType;
    }

    public boolean equals(Object obj) {
        return obj != null && this.getClass().equals(obj.getClass()) && this.myComponentType.equals(((PsiArrayType)obj).getComponentType());
    }

    public int hashCode() {
        return this.myComponentType.hashCode() * 3;
    }
}

