/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.ArrayFactory;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;

public interface PsiElement
extends UserDataHolder,
Iconable {
    public static final PsiElement[] EMPTY_ARRAY = new PsiElement[0];
    public static final ArrayFactory<PsiElement> ARRAY_FACTORY = new ArrayFactory<PsiElement>(){

        public PsiElement[] create(int count) {
            return count == 0 ? EMPTY_ARRAY : new PsiElement[count];
        }
    };

    public Project getProject() throws PsiInvalidElementAccessException;

    public Language getLanguage();

    public PsiManager getManager();

    public PsiElement[] getChildren();

    public PsiElement getParent();

    public PsiElement getFirstChild();

    public PsiElement getLastChild();

    public PsiElement getNextSibling();

    public PsiElement getPrevSibling();

    public PsiFile getContainingFile() throws PsiInvalidElementAccessException;

    public TextRange getTextRange();

    public int getStartOffsetInParent();

    public int getTextLength();

    public PsiElement findElementAt(int var1);

    public PsiReference findReferenceAt(int var1);

    public int getTextOffset();

    @NonNls
    public String getText();

    public char[] textToCharArray();

    public PsiElement getNavigationElement();

    public PsiElement getOriginalElement();

    public boolean textMatches(@NonNls CharSequence var1);

    public boolean textMatches(PsiElement var1);

    public boolean textContains(char var1);

    public void accept(PsiElementVisitor var1);

    public void acceptChildren(PsiElementVisitor var1);

    public PsiElement copy();

    public PsiElement add(PsiElement var1) throws IncorrectOperationException;

    public PsiElement addBefore(PsiElement var1, PsiElement var2) throws IncorrectOperationException;

    public PsiElement addAfter(PsiElement var1, PsiElement var2) throws IncorrectOperationException;

    public void checkAdd(PsiElement var1) throws IncorrectOperationException;

    public PsiElement addRange(PsiElement var1, PsiElement var2) throws IncorrectOperationException;

    public PsiElement addRangeBefore(PsiElement var1, PsiElement var2, PsiElement var3) throws IncorrectOperationException;

    public PsiElement addRangeAfter(PsiElement var1, PsiElement var2, PsiElement var3) throws IncorrectOperationException;

    public void delete() throws IncorrectOperationException;

    public void checkDelete() throws IncorrectOperationException;

    public void deleteChildRange(PsiElement var1, PsiElement var2) throws IncorrectOperationException;

    public PsiElement replace(PsiElement var1) throws IncorrectOperationException;

    public boolean isValid();

    public boolean isWritable();

    public PsiReference getReference();

    public PsiReference[] getReferences();

    public <T> T getCopyableUserData(Key<T> var1);

    public <T> void putCopyableUserData(Key<T> var1, T var2);

    public boolean processDeclarations(PsiScopeProcessor var1, ResolveState var2, PsiElement var3, PsiElement var4);

    public PsiElement getContext();

    public boolean isPhysical();

    public GlobalSearchScope getResolveScope();

    public SearchScope getUseScope();

    public ASTNode getNode();

    @NonNls
    public String toString();

    public boolean isEquivalentTo(PsiElement var1);
}

