/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class PsiElementFinder {
    public static final ExtensionPointName<PsiElementFinder> EP_NAME = ExtensionPointName.create((String)"com.intellij.java.elementFinder");

    public abstract PsiClass findClass(String var1, GlobalSearchScope var2);

    public abstract PsiClass[] findClasses(String var1, GlobalSearchScope var2);

    public PsiPackage findPackage(String qualifiedName) {
        return null;
    }

    public PsiPackage[] getSubPackages(PsiPackage psiPackage, GlobalSearchScope scope) {
        return PsiPackage.EMPTY_ARRAY;
    }

    public PsiClass[] getClasses(PsiPackage psiPackage, GlobalSearchScope scope) {
        return PsiClass.EMPTY_ARRAY;
    }

    public Condition<PsiClass> getClassesFilter(GlobalSearchScope scope) {
        return null;
    }

    public PsiFile[] getPackageFiles(PsiPackage psiPackage, GlobalSearchScope scope) {
        return PsiFile.EMPTY_ARRAY;
    }

    public Condition<PsiFile> getPackageFilesFilter(PsiPackage psiPackage, GlobalSearchScope scope) {
        return null;
    }

    public Set<String> getClassNames(PsiPackage psiPackage, GlobalSearchScope scope) {
        return PsiElementFinder.getClassNames(this.getClasses(psiPackage, scope));
    }

    protected static Set<String> getClassNames(PsiClass[] classes) {
        if (classes.length == 0) {
            return Collections.emptySet();
        }
        HashSet<String> names = new HashSet<String>();
        for (PsiClass aClass : classes) {
            ContainerUtil.addIfNotNull((Object)aClass.getName(), names);
        }
        return names;
    }

    public boolean processPackageDirectories(PsiPackage psiPackage, GlobalSearchScope scope, Processor<PsiDirectory> consumer) {
        return this.processPackageDirectories(psiPackage, scope, consumer, false);
    }

    public boolean processPackageDirectories(PsiPackage psiPackage, GlobalSearchScope scope, Processor<PsiDirectory> consumer, boolean includeLibrarySources) {
        return true;
    }

    public PsiClass[] getClasses(String className, PsiPackage psiPackage, GlobalSearchScope scope) {
        PsiClass[] allClasses = this.getClasses(psiPackage, scope);
        if (className == null) {
            return allClasses;
        }
        return PsiElementFinder.filterByName(className, allClasses);
    }

    public static PsiClass[] filterByName(String className, PsiClass[] classes) {
        if (classes.length == 0) {
            return PsiClass.EMPTY_ARRAY;
        }
        if (classes.length == 1) {
            return className.equals(classes[0].getName()) ? classes : PsiClass.EMPTY_ARRAY;
        }
        SmartList foundClasses = new SmartList();
        for (PsiClass psiClass : classes) {
            if (!className.equals(psiClass.getName())) continue;
            foundClasses.add(psiClass);
        }
        return foundClasses.isEmpty() ? PsiClass.EMPTY_ARRAY : foundClasses.toArray(new PsiClass[foundClasses.size()]);
    }
}

