/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;

public class PsiIntersectionType
extends PsiType.Stub {
    private final PsiType[] myConjuncts;

    private PsiIntersectionType(PsiType[] conjuncts) {
        super(PsiAnnotation.EMPTY_ARRAY);
        this.myConjuncts = conjuncts;
    }

    public static PsiType createIntersection(List<PsiType> conjuncts) {
        return PsiIntersectionType.createIntersection(conjuncts.toArray(PsiIntersectionType.createArray(conjuncts.size())));
    }

    public static PsiType createIntersection(PsiType ... conjuncts) {
        return PsiIntersectionType.createIntersection(true, conjuncts);
    }

    public static PsiType createIntersection(boolean flatten, PsiType ... conjuncts) {
        assert (conjuncts.length > 0);
        if (flatten) {
            conjuncts = PsiIntersectionType.flattenAndRemoveDuplicates(conjuncts);
        }
        if (conjuncts.length == 1) {
            return conjuncts[0];
        }
        return new PsiIntersectionType(conjuncts);
    }

    private static PsiType[] flattenAndRemoveDuplicates(PsiType[] conjuncts) {
        try {
            Set<PsiType> flattened = PsiIntersectionType.flatten(conjuncts, ContainerUtil.newLinkedHashSet());
            return flattened.toArray(PsiIntersectionType.createArray(flattened.size()));
        }
        catch (NoSuchElementException e) {
            throw new RuntimeException(Arrays.toString(conjuncts), e);
        }
    }

    private static Set<PsiType> flatten(PsiType[] conjuncts, Set<PsiType> types) {
        for (PsiType conjunct : conjuncts) {
            if (conjunct instanceof PsiIntersectionType) {
                PsiIntersectionType type = (PsiIntersectionType)conjunct;
                PsiIntersectionType.flatten(type.getConjuncts(), types);
                continue;
            }
            types.add(conjunct);
        }
        if (types.size() > 1) {
            PsiType[] array = types.toArray(PsiIntersectionType.createArray(types.size()));
            Iterator<PsiType> iterator = types.iterator();
            block1: while (iterator.hasNext()) {
                PsiType type = iterator.next();
                for (PsiType existing : array) {
                    boolean allowUncheckedConversion;
                    if (type == existing) continue;
                    boolean bl = allowUncheckedConversion = type instanceof PsiClassType && ((PsiClassType)type).isRaw();
                    if (!TypeConversionUtil.isAssignable(type, existing, allowUncheckedConversion) && !TypeConversionUtil.isAssignable(GenericsUtil.eliminateWildcards(type), GenericsUtil.eliminateWildcards(existing), allowUncheckedConversion)) continue;
                    iterator.remove();
                    continue block1;
                }
            }
            if (types.isEmpty()) {
                types.add(array[0]);
            }
        }
        return types;
    }

    public PsiType[] getConjuncts() {
        return this.myConjuncts;
    }

    @Override
    public String getPresentableText() {
        return StringUtil.join((Object[])this.myConjuncts, (Function)new Function<PsiType, String>(){

            public String fun(PsiType psiType) {
                return psiType.getPresentableText();
            }
        }, (String)" & ");
    }

    @Override
    public String getCanonicalText(boolean annotated) {
        return this.myConjuncts[0].getCanonicalText(annotated);
    }

    @Override
    public String getInternalCanonicalText() {
        return StringUtil.join((Object[])this.myConjuncts, (Function)new Function<PsiType, String>(){

            public String fun(PsiType psiType) {
                return psiType.getInternalCanonicalText();
            }
        }, (String)" & ");
    }

    @Override
    public boolean isValid() {
        for (PsiType conjunct : this.myConjuncts) {
            if (conjunct.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equalsToText(String text) {
        return false;
    }

    @Override
    public <A> A accept(PsiTypeVisitor<A> visitor) {
        return visitor.visitIntersectionType(this);
    }

    @Override
    public GlobalSearchScope getResolveScope() {
        return this.myConjuncts[0].getResolveScope();
    }

    @Override
    public PsiType[] getSuperTypes() {
        return this.myConjuncts;
    }

    public PsiType getRepresentative() {
        return this.myConjuncts[0];
    }

    public boolean equals(Object obj) {
        PsiType[] second;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PsiIntersectionType)) {
            return false;
        }
        PsiType[] first = this.getConjuncts();
        if (first.length != (second = ((PsiIntersectionType)obj).getConjuncts()).length) {
            return false;
        }
        for (int i = 0; i < first.length; ++i) {
            if (first[i].equals(second[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.myConjuncts[0].hashCode();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("PsiIntersectionType: ");
        for (int i = 0; i < this.myConjuncts.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.myConjuncts[i].getPresentableText());
        }
        return sb.toString();
    }
}

