/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWalkingState;
import java.util.List;

public abstract class PsiRecursiveElementWalkingVisitor
extends PsiElementVisitor {
    private final boolean myVisitAllFileRoots;
    private final PsiWalkingState myWalkingState = new PsiWalkingState(this){

        public void elementFinished(PsiElement element) {
            PsiRecursiveElementWalkingVisitor.this.elementFinished(element);
        }
    };

    protected PsiRecursiveElementWalkingVisitor() {
        this(false);
    }

    protected PsiRecursiveElementWalkingVisitor(boolean visitAllFileRoots) {
        this.myVisitAllFileRoots = visitAllFileRoots;
    }

    @Override
    public void visitElement(PsiElement element) {
        ProgressIndicatorProvider.checkCanceled();
        this.myWalkingState.elementStarted(element);
    }

    protected void elementFinished(PsiElement element) {
    }

    @Override
    public void visitFile(PsiFile file) {
        FileViewProvider viewProvider;
        List<PsiFile> allFiles;
        if (this.myVisitAllFileRoots && (allFiles = (viewProvider = file.getViewProvider()).getAllFiles()).size() > 1 && file == viewProvider.getPsi(viewProvider.getBaseLanguage())) {
            for (PsiFile lFile : allFiles) {
                lFile.acceptChildren(this);
            }
            return;
        }
        super.visitFile(file);
    }

    public void stopWalking() {
        this.myWalkingState.stopWalking();
    }
}

