/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayFactory;
import org.jetbrains.annotations.NonNls;

public abstract class PsiType
implements PsiAnnotationOwner {
    public static final PsiPrimitiveType BYTE = new PsiPrimitiveType("byte", "java.lang.Byte");
    public static final PsiPrimitiveType CHAR = new PsiPrimitiveType("char", "java.lang.Character");
    public static final PsiPrimitiveType DOUBLE = new PsiPrimitiveType("double", "java.lang.Double");
    public static final PsiPrimitiveType FLOAT = new PsiPrimitiveType("float", "java.lang.Float");
    public static final PsiPrimitiveType INT = new PsiPrimitiveType("int", "java.lang.Integer");
    public static final PsiPrimitiveType LONG = new PsiPrimitiveType("long", "java.lang.Long");
    public static final PsiPrimitiveType SHORT = new PsiPrimitiveType("short", "java.lang.Short");
    public static final PsiPrimitiveType BOOLEAN = new PsiPrimitiveType("boolean", "java.lang.Boolean");
    public static final PsiPrimitiveType VOID = new PsiPrimitiveType("void", "java.lang.Void");
    public static final PsiPrimitiveType NULL = new PsiPrimitiveType("null", (String)null);
    public static final PsiType[] EMPTY_ARRAY = new PsiType[0];
    public static final ArrayFactory<PsiType> ARRAY_FACTORY = new ArrayFactory<PsiType>(){

        public PsiType[] create(int count) {
            return count == 0 ? EMPTY_ARRAY : new PsiType[count];
        }
    };
    private final PsiAnnotation[] myAnnotations;

    public static PsiType[] createArray(int count) {
        return (PsiType[])ARRAY_FACTORY.create(count);
    }

    protected PsiType(PsiAnnotation[] annotations) {
        this.myAnnotations = annotations;
    }

    public PsiArrayType createArrayType() {
        return new PsiArrayType(this);
    }

    public PsiArrayType createArrayType(PsiAnnotation ... annotations) {
        return new PsiArrayType(this, annotations);
    }

    @NonNls
    public abstract String getPresentableText();

    @NonNls
    public String getCanonicalText(boolean annotated) {
        return this.getCanonicalText();
    }

    @NonNls
    public abstract String getCanonicalText();

    @NonNls
    public abstract String getInternalCanonicalText();

    public abstract boolean isValid();

    public boolean isAssignableFrom(PsiType type) {
        return TypeConversionUtil.isAssignable(this, type);
    }

    public boolean isConvertibleFrom(PsiType type) {
        return TypeConversionUtil.areTypesConvertible(type, this);
    }

    public abstract boolean equalsToText(@NonNls String var1);

    public static PsiClassType getTypeByName(String qName, Project project, GlobalSearchScope resolveScope) {
        PsiElementFactory factory = JavaPsiFacade.getInstance(project).getElementFactory();
        return factory.createTypeByFQClassName(qName, resolveScope);
    }

    public static PsiClassType getJavaLangObject(PsiManager manager, GlobalSearchScope resolveScope) {
        return PsiType.getTypeByName("java.lang.Object", manager.getProject(), resolveScope);
    }

    public static PsiClassType getJavaLangClass(PsiManager manager, GlobalSearchScope resolveScope) {
        return PsiType.getTypeByName("java.lang.Class", manager.getProject(), resolveScope);
    }

    public static PsiClassType getJavaLangThrowable(PsiManager manager, GlobalSearchScope resolveScope) {
        return PsiType.getTypeByName("java.lang.Throwable", manager.getProject(), resolveScope);
    }

    public static PsiClassType getJavaLangString(PsiManager manager, GlobalSearchScope resolveScope) {
        return PsiType.getTypeByName("java.lang.String", manager.getProject(), resolveScope);
    }

    public static PsiClassType getJavaLangError(PsiManager manager, GlobalSearchScope resolveScope) {
        return PsiType.getTypeByName("java.lang.Error", manager.getProject(), resolveScope);
    }

    public static PsiClassType getJavaLangRuntimeException(PsiManager manager, GlobalSearchScope resolveScope) {
        return PsiType.getTypeByName("java.lang.RuntimeException", manager.getProject(), resolveScope);
    }

    public abstract <A> A accept(PsiTypeVisitor<A> var1);

    public final int getArrayDimensions() {
        PsiType type = this;
        int dims = 0;
        while (type instanceof PsiArrayType) {
            ++dims;
            type = ((PsiArrayType)type).getComponentType();
        }
        return dims;
    }

    public final PsiType getDeepComponentType() {
        PsiType type = this;
        while (type instanceof PsiArrayType) {
            type = ((PsiArrayType)type).getComponentType();
        }
        return type;
    }

    public abstract GlobalSearchScope getResolveScope();

    public abstract PsiType[] getSuperTypes();

    @Override
    public PsiAnnotation[] getAnnotations() {
        return this.myAnnotations;
    }

    @Override
    public PsiAnnotation findAnnotation(@NonNls String qualifiedName) {
        for (PsiAnnotation annotation : this.myAnnotations) {
            if (!qualifiedName.equals(annotation.getQualifiedName())) continue;
            return annotation;
        }
        return null;
    }

    @Override
    public PsiAnnotation addAnnotation(@NonNls String qualifiedName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PsiAnnotation[] getApplicableAnnotations() {
        return this.getAnnotations();
    }

    protected String getAnnotationsTextPrefix(boolean qualified, boolean leadingSpace, boolean trailingSpace) {
        PsiAnnotation[] annotations = this.getAnnotations();
        if (annotations.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (leadingSpace) {
            sb.append(' ');
        }
        if (PsiNameHelper.appendAnnotations(sb, annotations, qualified) && !trailingSpace) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public String toString() {
        return "PsiType:" + this.getPresentableText();
    }

    protected static abstract class Stub
    extends PsiType {
        protected Stub(PsiAnnotation[] annotations) {
            super(annotations);
        }

        @Override
        public final String getCanonicalText() {
            return this.getCanonicalText(false);
        }

        @Override
        public abstract String getCanonicalText(boolean var1);
    }
}

