/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.augment;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class PsiAugmentProvider {
    private static final Logger LOG = Logger.getInstance((String)("#" + PsiAugmentProvider.class.getName()));
    public static final ExtensionPointName<PsiAugmentProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.lang.psiAugmentProvider");

    public abstract <Psi extends PsiElement> List<Psi> getAugments(PsiElement var1, Class<Psi> var2);

    public static <Psi extends PsiElement> List<Psi> collectAugments(PsiElement element, Class<Psi> type) {
        List result = Collections.emptyList();
        for (PsiAugmentProvider provider : (PsiAugmentProvider[])Extensions.getExtensions(EP_NAME)) {
            List<Psi> augments = provider.getAugments(element, type);
            if (augments.isEmpty()) continue;
            if (result.isEmpty()) {
                result = new ArrayList(augments.size());
            }
            result.addAll(augments);
        }
        return result;
    }

    protected PsiType inferType(PsiTypeElement typeElement) {
        return null;
    }

    public static PsiType getInferredType(PsiTypeElement typeElement) {
        for (PsiAugmentProvider provider : (PsiAugmentProvider[])Extensions.getExtensions(EP_NAME)) {
            try {
                PsiType type = provider.inferType(typeElement);
                if (type == null) continue;
                return type;
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error("provider: " + provider, (Throwable)e);
            }
        }
        return null;
    }
}

