/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.Indent;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ThrowableRunnable;
import java.util.Collection;

public abstract class CodeStyleManager {
    public static CodeStyleManager getInstance(Project project) {
        return ServiceManager.getService(project, CodeStyleManager.class);
    }

    public static CodeStyleManager getInstance(PsiManager manager) {
        return CodeStyleManager.getInstance(manager.getProject());
    }

    public abstract Project getProject();

    public abstract PsiElement reformat(PsiElement var1) throws IncorrectOperationException;

    public abstract PsiElement reformat(PsiElement var1, boolean var2) throws IncorrectOperationException;

    public abstract PsiElement reformatRange(PsiElement var1, int var2, int var3) throws IncorrectOperationException;

    public abstract PsiElement reformatRange(PsiElement var1, int var2, int var3, boolean var4) throws IncorrectOperationException;

    public abstract void reformatText(PsiFile var1, int var2, int var3) throws IncorrectOperationException;

    public abstract void reformatText(PsiFile var1, Collection<TextRange> var2) throws IncorrectOperationException;

    public abstract void adjustLineIndent(PsiFile var1, TextRange var2) throws IncorrectOperationException;

    public abstract int adjustLineIndent(PsiFile var1, int var2) throws IncorrectOperationException;

    public abstract int adjustLineIndent(Document var1, int var2);

    public abstract boolean isLineToBeIndented(PsiFile var1, int var2);

    public abstract String getLineIndent(PsiFile var1, int var2);

    public abstract String getLineIndent(Document var1, int var2);

    public abstract Indent getIndent(String var1, FileType var2);

    public abstract String fillIndent(Indent var1, FileType var2);

    public abstract Indent zeroIndent();

    public abstract void reformatNewlyAddedElement(ASTNode var1, ASTNode var2) throws IncorrectOperationException;

    public abstract boolean isSequentialProcessingAllowed();

    public abstract void performActionWithFormatterDisabled(Runnable var1);

    public abstract <T extends Throwable> void performActionWithFormatterDisabled(ThrowableRunnable<T> var1) throws T;

    public abstract <T> T performActionWithFormatterDisabled(Computable<T> var1);
}

