/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.DifferenceFilter;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.FileIndentOptionsProvider;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import java.lang.reflect.Field;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class CommonCodeStyleSettings {
    @NonNls
    private static final String ARRANGEMENT_ELEMENT_NAME = "arrangement";
    private final Language myLanguage;
    private ArrangementSettings myArrangementSettings;
    private CodeStyleSettings myRootSettings;
    private IndentOptions myIndentOptions;
    private final FileType myFileType;
    private boolean myForceArrangeMenuAvailable;
    @NonNls
    private static final String INDENT_OPTIONS_TAG = "indentOptions";
    public int RIGHT_MARGIN = -1;
    public boolean LINE_COMMENT_AT_FIRST_COLUMN = true;
    public boolean BLOCK_COMMENT_AT_FIRST_COLUMN = true;
    public boolean KEEP_LINE_BREAKS = true;
    public boolean KEEP_FIRST_COLUMN_COMMENT = true;
    public boolean INSERT_FIRST_SPACE_IN_LINE = true;
    public boolean KEEP_CONTROL_STATEMENT_IN_ONE_LINE = true;
    public int KEEP_BLANK_LINES_IN_DECLARATIONS = 2;
    public int KEEP_BLANK_LINES_IN_CODE = 2;
    public int KEEP_BLANK_LINES_BEFORE_RBRACE = 2;
    public int BLANK_LINES_BEFORE_PACKAGE = 0;
    public int BLANK_LINES_AFTER_PACKAGE = 1;
    public int BLANK_LINES_BEFORE_IMPORTS = 1;
    public int BLANK_LINES_AFTER_IMPORTS = 1;
    public int BLANK_LINES_AROUND_CLASS = 1;
    public int BLANK_LINES_AROUND_FIELD = 0;
    public int BLANK_LINES_AROUND_METHOD = 1;
    public int BLANK_LINES_BEFORE_METHOD_BODY = 0;
    public int BLANK_LINES_AROUND_FIELD_IN_INTERFACE = 0;
    public int BLANK_LINES_AROUND_METHOD_IN_INTERFACE = 1;
    public int BLANK_LINES_AFTER_CLASS_HEADER = 0;
    public int BLANK_LINES_AFTER_ANONYMOUS_CLASS_HEADER = 0;
    public static final int END_OF_LINE = 1;
    public static final int NEXT_LINE = 2;
    public static final int NEXT_LINE_SHIFTED = 3;
    public static final int NEXT_LINE_SHIFTED2 = 4;
    public static final int NEXT_LINE_IF_WRAPPED = 5;
    @BraceStyleConstant
    public int BRACE_STYLE = 1;
    @BraceStyleConstant
    public int CLASS_BRACE_STYLE = 1;
    @BraceStyleConstant
    public int METHOD_BRACE_STYLE = 1;
    public boolean USE_FLYING_GEESE_BRACES = false;
    public int FLYING_GEESE_BRACES_GAP = 1;
    public boolean DO_NOT_INDENT_TOP_LEVEL_CLASS_MEMBERS = false;
    public boolean ELSE_ON_NEW_LINE = false;
    public boolean WHILE_ON_NEW_LINE = false;
    public boolean CATCH_ON_NEW_LINE = false;
    public boolean FINALLY_ON_NEW_LINE = false;
    public boolean INDENT_CASE_FROM_SWITCH = true;
    public boolean INDENT_BREAK_FROM_CASE = true;
    public boolean SPECIAL_ELSE_IF_TREATMENT = true;
    public boolean ALIGN_MULTILINE_CHAINED_METHODS = false;
    public boolean ALIGN_MULTILINE_PARAMETERS = true;
    public boolean ALIGN_MULTILINE_PARAMETERS_IN_CALLS = false;
    public boolean ALIGN_MULTILINE_RESOURCES = true;
    public boolean ALIGN_MULTILINE_FOR = true;
    public boolean INDENT_WHEN_CASES = true;
    public boolean ALIGN_MULTILINE_BINARY_OPERATION = false;
    public boolean ALIGN_MULTILINE_ASSIGNMENT = false;
    public boolean ALIGN_MULTILINE_TERNARY_OPERATION = false;
    public boolean ALIGN_MULTILINE_THROWS_LIST = false;
    public boolean ALIGN_THROWS_KEYWORD = false;
    public boolean ALIGN_MULTILINE_EXTENDS_LIST = false;
    public boolean ALIGN_MULTILINE_METHOD_BRACKETS = false;
    public boolean ALIGN_MULTILINE_PARENTHESIZED_EXPRESSION = false;
    public boolean ALIGN_MULTILINE_ARRAY_INITIALIZER_EXPRESSION = false;
    public boolean ALIGN_GROUP_FIELD_DECLARATIONS = false;
    public boolean ALIGN_CONSECUTIVE_VARIABLE_DECLARATIONS = false;
    public boolean SPACE_AROUND_ASSIGNMENT_OPERATORS = true;
    public boolean SPACE_AROUND_LOGICAL_OPERATORS = true;
    public boolean SPACE_AROUND_EQUALITY_OPERATORS = true;
    public boolean SPACE_AROUND_RELATIONAL_OPERATORS = true;
    public boolean SPACE_AROUND_BITWISE_OPERATORS = true;
    public boolean SPACE_AROUND_ADDITIVE_OPERATORS = true;
    public boolean SPACE_AROUND_MULTIPLICATIVE_OPERATORS = true;
    public boolean SPACE_AROUND_SHIFT_OPERATORS = true;
    public boolean SPACE_AROUND_UNARY_OPERATOR = false;
    public boolean SPACE_AROUND_LAMBDA_ARROW = true;
    public boolean SPACE_AROUND_METHOD_REF_DBL_COLON = false;
    public boolean SPACE_AFTER_COMMA = true;
    public boolean SPACE_AFTER_COMMA_IN_TYPE_ARGUMENTS = true;
    public boolean SPACE_BEFORE_COMMA = false;
    public boolean SPACE_AFTER_SEMICOLON = true;
    public boolean SPACE_BEFORE_SEMICOLON = false;
    public boolean SPACE_WITHIN_PARENTHESES = false;
    public boolean SPACE_WITHIN_METHOD_CALL_PARENTHESES = false;
    public boolean SPACE_WITHIN_EMPTY_METHOD_CALL_PARENTHESES = false;
    public boolean SPACE_WITHIN_METHOD_PARENTHESES = false;
    public boolean SPACE_WITHIN_EMPTY_METHOD_PARENTHESES = false;
    public boolean SPACE_WITHIN_IF_PARENTHESES = false;
    public boolean SPACE_WITHIN_WHILE_PARENTHESES = false;
    public boolean SPACE_WITHIN_FOR_PARENTHESES = false;
    public boolean SPACE_WITHIN_TRY_PARENTHESES = false;
    public boolean SPACE_WITHIN_CATCH_PARENTHESES = false;
    public boolean SPACE_WITHIN_SWITCH_PARENTHESES = false;
    public boolean SPACE_WITHIN_SYNCHRONIZED_PARENTHESES = false;
    public boolean SPACE_WITHIN_CAST_PARENTHESES = false;
    public boolean SPACE_WITHIN_BRACKETS = false;
    public boolean SPACE_WITHIN_BRACES = false;
    public boolean SPACE_WITHIN_ARRAY_INITIALIZER_BRACES = false;
    public boolean SPACE_WITHIN_EMPTY_ARRAY_INITIALIZER_BRACES = false;
    public boolean SPACE_AFTER_TYPE_CAST = true;
    public boolean SPACE_BEFORE_METHOD_CALL_PARENTHESES = false;
    public boolean SPACE_BEFORE_METHOD_PARENTHESES = false;
    public boolean SPACE_BEFORE_IF_PARENTHESES = true;
    public boolean SPACE_BEFORE_WHILE_PARENTHESES = true;
    public boolean SPACE_BEFORE_FOR_PARENTHESES = true;
    public boolean SPACE_BEFORE_TRY_PARENTHESES = true;
    public boolean SPACE_BEFORE_CATCH_PARENTHESES = true;
    public boolean SPACE_BEFORE_SWITCH_PARENTHESES = true;
    public boolean SPACE_BEFORE_SYNCHRONIZED_PARENTHESES = true;
    public boolean SPACE_BEFORE_CLASS_LBRACE = true;
    public boolean SPACE_BEFORE_METHOD_LBRACE = true;
    public boolean SPACE_BEFORE_IF_LBRACE = true;
    public boolean SPACE_BEFORE_ELSE_LBRACE = true;
    public boolean SPACE_BEFORE_WHILE_LBRACE = true;
    public boolean SPACE_BEFORE_FOR_LBRACE = true;
    public boolean SPACE_BEFORE_DO_LBRACE = true;
    public boolean SPACE_BEFORE_SWITCH_LBRACE = true;
    public boolean SPACE_BEFORE_TRY_LBRACE = true;
    public boolean SPACE_BEFORE_CATCH_LBRACE = true;
    public boolean SPACE_BEFORE_FINALLY_LBRACE = true;
    public boolean SPACE_BEFORE_SYNCHRONIZED_LBRACE = true;
    public boolean SPACE_BEFORE_ARRAY_INITIALIZER_LBRACE = false;
    public boolean SPACE_BEFORE_ANNOTATION_ARRAY_INITIALIZER_LBRACE = false;
    public boolean SPACE_BEFORE_ELSE_KEYWORD = true;
    public boolean SPACE_BEFORE_WHILE_KEYWORD = true;
    public boolean SPACE_BEFORE_CATCH_KEYWORD = true;
    public boolean SPACE_BEFORE_FINALLY_KEYWORD = true;
    public boolean SPACE_BEFORE_QUEST = true;
    public boolean SPACE_AFTER_QUEST = true;
    public boolean SPACE_BEFORE_COLON = true;
    public boolean SPACE_AFTER_COLON = true;
    public boolean SPACE_BEFORE_TYPE_PARAMETER_LIST = false;
    public static final int DO_NOT_WRAP = 0;
    public static final int WRAP_AS_NEEDED = 1;
    public static final int WRAP_ALWAYS = 2;
    public static final int WRAP_ON_EVERY_ITEM = 4;
    public int CALL_PARAMETERS_WRAP = 0;
    public boolean PREFER_PARAMETERS_WRAP = false;
    public boolean CALL_PARAMETERS_LPAREN_ON_NEXT_LINE = false;
    public boolean CALL_PARAMETERS_RPAREN_ON_NEXT_LINE = false;
    public int METHOD_PARAMETERS_WRAP = 0;
    public boolean METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE = false;
    public boolean METHOD_PARAMETERS_RPAREN_ON_NEXT_LINE = false;
    public int RESOURCE_LIST_WRAP = 0;
    public boolean RESOURCE_LIST_LPAREN_ON_NEXT_LINE = false;
    public boolean RESOURCE_LIST_RPAREN_ON_NEXT_LINE = false;
    public int EXTENDS_LIST_WRAP = 0;
    public int THROWS_LIST_WRAP = 0;
    public int EXTENDS_KEYWORD_WRAP = 0;
    public int THROWS_KEYWORD_WRAP = 0;
    public int METHOD_CALL_CHAIN_WRAP = 0;
    public boolean PARENTHESES_EXPRESSION_LPAREN_WRAP = false;
    public boolean PARENTHESES_EXPRESSION_RPAREN_WRAP = false;
    public int BINARY_OPERATION_WRAP = 0;
    public boolean BINARY_OPERATION_SIGN_ON_NEXT_LINE = false;
    public int TERNARY_OPERATION_WRAP = 0;
    public boolean TERNARY_OPERATION_SIGNS_ON_NEXT_LINE = false;
    public boolean MODIFIER_LIST_WRAP = false;
    public boolean KEEP_SIMPLE_BLOCKS_IN_ONE_LINE = false;
    public boolean KEEP_SIMPLE_METHODS_IN_ONE_LINE = false;
    public boolean KEEP_SIMPLE_CLASSES_IN_ONE_LINE = false;
    public boolean KEEP_MULTIPLE_EXPRESSIONS_IN_ONE_LINE = false;
    public int FOR_STATEMENT_WRAP = 0;
    public boolean FOR_STATEMENT_LPAREN_ON_NEXT_LINE = false;
    public boolean FOR_STATEMENT_RPAREN_ON_NEXT_LINE = false;
    public int ARRAY_INITIALIZER_WRAP = 0;
    public boolean ARRAY_INITIALIZER_LBRACE_ON_NEXT_LINE = false;
    public boolean ARRAY_INITIALIZER_RBRACE_ON_NEXT_LINE = false;
    public int ASSIGNMENT_WRAP = 0;
    public boolean PLACE_ASSIGNMENT_SIGN_ON_NEXT_LINE = false;
    public int LABELED_STATEMENT_WRAP = 2;
    public boolean WRAP_COMMENTS = false;
    public int ASSERT_STATEMENT_WRAP = 0;
    public boolean ASSERT_STATEMENT_COLON_ON_NEXT_LINE = false;
    public static final int DO_NOT_FORCE = 0;
    public static final int FORCE_BRACES_IF_MULTILINE = 1;
    public static final int FORCE_BRACES_ALWAYS = 3;
    public int IF_BRACE_FORCE = 0;
    public int DOWHILE_BRACE_FORCE = 0;
    public int WHILE_BRACE_FORCE = 0;
    public int FOR_BRACE_FORCE = 0;
    public boolean WRAP_LONG_LINES = false;
    public int METHOD_ANNOTATION_WRAP = 2;
    public int CLASS_ANNOTATION_WRAP = 2;
    public int FIELD_ANNOTATION_WRAP = 2;
    public int PARAMETER_ANNOTATION_WRAP = 0;
    public int VARIABLE_ANNOTATION_WRAP = 0;
    public boolean SPACE_BEFORE_ANOTATION_PARAMETER_LIST = false;
    public boolean SPACE_WITHIN_ANNOTATION_PARENTHESES = false;
    public int ENUM_CONSTANTS_WRAP = 0;
    public boolean PARENT_SETTINGS_INSTALLED = false;
    public static int REARRANGE_ACCORDIND_TO_DIALOG = 0;
    public static int REARRANGE_ALWAYS = 1;
    public static int REARRANGE_NEVER = 2;
    public int FORCE_REARRANGE_MODE = REARRANGE_ACCORDIND_TO_DIALOG;

    public CommonCodeStyleSettings(Language language, FileType fileType) {
        this.myLanguage = language;
        this.myFileType = fileType;
    }

    public CommonCodeStyleSettings(Language language) {
        this(language, language == null ? null : language.getAssociatedFileType());
    }

    void setRootSettings(CodeStyleSettings rootSettings) {
        this.myRootSettings = rootSettings;
    }

    public Language getLanguage() {
        return this.myLanguage;
    }

    public IndentOptions initIndentOptions() {
        this.myIndentOptions = new IndentOptions();
        return this.myIndentOptions;
    }

    public FileType getFileType() {
        return this.myFileType;
    }

    public CodeStyleSettings getRootSettings() {
        return this.myRootSettings;
    }

    public IndentOptions getIndentOptions() {
        return this.myIndentOptions;
    }

    public ArrangementSettings getArrangementSettings() {
        return this.myArrangementSettings;
    }

    public void setArrangementSettings(ArrangementSettings settings) {
        this.myArrangementSettings = settings;
    }

    public void setForceArrangeMenuAvailable(boolean value) {
        this.myForceArrangeMenuAvailable = value;
    }

    public boolean isForceArrangeMenuAvailable() {
        return this.myForceArrangeMenuAvailable;
    }

    public CommonCodeStyleSettings clone(CodeStyleSettings rootSettings) {
        CommonCodeStyleSettings commonSettings = new CommonCodeStyleSettings(this.myLanguage, this.getFileType());
        CommonCodeStyleSettings.copyPublicFields(this, commonSettings);
        commonSettings.setRootSettings(rootSettings);
        commonSettings.myForceArrangeMenuAvailable = this.myForceArrangeMenuAvailable;
        if (this.myIndentOptions != null) {
            IndentOptions targetIndentOptions = commonSettings.initIndentOptions();
            targetIndentOptions.copyFrom(this.myIndentOptions);
        }
        if (this.myArrangementSettings != null) {
            commonSettings.setArrangementSettings(this.myArrangementSettings.clone());
        }
        return commonSettings;
    }

    protected static void copyPublicFields(Object from, Object to) {
        assert (from != to);
        ReflectionUtil.copyFields((Field[])to.getClass().getFields(), (Object)from, (Object)to);
    }

    void copyNonDefaultValuesFrom(CommonCodeStyleSettings from) {
        CommonCodeStyleSettings defaultSettings = new CommonCodeStyleSettings(null);
        this.PARENT_SETTINGS_INSTALLED = ReflectionUtil.copyFields((Field[])this.getClass().getFields(), (Object)from, (Object)this, (DifferenceFilter)new SupportedFieldsDiffFilter(from, this.getSupportedFields(), defaultSettings){

            @Override
            public boolean isAccept(Field field) {
                if ("RIGHT_MARGIN".equals(field.getName())) {
                    return false;
                }
                return super.isAccept(field);
            }
        });
    }

    private CommonCodeStyleSettings getDefaultSettings() {
        return LanguageCodeStyleSettingsProvider.getDefaultCommonSettings(this.myLanguage);
    }

    public void readExternal(Element element) throws InvalidDataException {
        Element arrangementRulesContainer;
        Element indentOptionsElement;
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        if (this.myIndentOptions != null && (indentOptionsElement = element.getChild(INDENT_OPTIONS_TAG)) != null) {
            this.myIndentOptions.deserialize(indentOptionsElement);
        }
        if ((arrangementRulesContainer = element.getChild(ARRANGEMENT_ELEMENT_NAME)) != null) {
            this.myArrangementSettings = ArrangementUtil.readExternal(arrangementRulesContainer, this.myLanguage);
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        CommonCodeStyleSettings defaultSettings = this.getDefaultSettings();
        Set<String> supportedFields = this.getSupportedFields();
        if (supportedFields != null) {
            supportedFields.add("PARENT_SETTINGS_INSTALLED");
            supportedFields.add("FORCE_REARRANGE_MODE");
        }
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element, (DefaultJDOMExternalizer.JDOMFilter)new SupportedFieldsDiffFilter(this, supportedFields, defaultSettings));
        if (this.myIndentOptions != null) {
            IndentOptions defaultIndentOptions = defaultSettings != null ? defaultSettings.getIndentOptions() : null;
            Element indentOptionsElement = new Element(INDENT_OPTIONS_TAG);
            this.myIndentOptions.serialize(indentOptionsElement, defaultIndentOptions);
            if (!indentOptionsElement.getChildren().isEmpty()) {
                element.addContent(indentOptionsElement);
            }
        }
        if (this.myArrangementSettings != null) {
            Element container = new Element(ARRANGEMENT_ELEMENT_NAME);
            ArrangementUtil.writeExternal(container, this.myArrangementSettings, this.myLanguage);
            if (!container.getChildren().isEmpty()) {
                element.addContent(container);
            }
        }
    }

    private Set<String> getSupportedFields() {
        LanguageCodeStyleSettingsProvider provider = LanguageCodeStyleSettingsProvider.forLanguage(this.myLanguage);
        return provider == null ? null : provider.getSupportedFields();
    }

    public static class IndentOptions
    implements JDOMExternalizable,
    Cloneable {
        public int INDENT_SIZE = 4;
        public int CONTINUATION_INDENT_SIZE = 8;
        public int TAB_SIZE = 4;
        public boolean USE_TAB_CHARACTER = false;
        public boolean SMART_TABS = false;
        public int LABEL_INDENT_SIZE = 0;
        public boolean LABEL_INDENT_ABSOLUTE = false;
        public boolean USE_RELATIVE_INDENTS = false;
        public boolean KEEP_INDENTS_ON_EMPTY_LINES = false;
        private FileIndentOptionsProvider myFileIndentOptionsProvider;
        private static final Key<IndentOptions> INDENT_OPTIONS_KEY = Key.create((String)"INDENT_OPTIONS_KEY");

        public void readExternal(Element element) throws InvalidDataException {
            DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        }

        public void writeExternal(Element element) throws WriteExternalException {
            DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element, (DefaultJDOMExternalizer.JDOMFilter)new DefaultJDOMExternalizer.JDOMFilter(){

                public boolean isAccept(Field field) {
                    if ("KEEP_INDENTS_ON_EMPTY_LINES".equals(field.getName())) {
                        return IndentOptions.this.KEEP_INDENTS_ON_EMPTY_LINES;
                    }
                    return true;
                }
            });
        }

        public void serialize(Element indentOptionsElement, final IndentOptions defaultOptions) {
            XmlSerializer.serializeInto((Object)this, (Element)indentOptionsElement, (SerializationFilter)new SkipDefaultValuesSerializationFilters(){

                protected void configure(Object o) {
                    if (o instanceof IndentOptions && defaultOptions != null) {
                        ((IndentOptions)o).copyFrom(defaultOptions);
                    }
                }
            });
        }

        public void deserialize(Element indentOptionsElement) {
            XmlSerializer.deserializeInto((Object)this, (Element)indentOptionsElement);
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IndentOptions that = (IndentOptions)o;
            if (this.CONTINUATION_INDENT_SIZE != that.CONTINUATION_INDENT_SIZE) {
                return false;
            }
            if (this.INDENT_SIZE != that.INDENT_SIZE) {
                return false;
            }
            if (this.LABEL_INDENT_ABSOLUTE != that.LABEL_INDENT_ABSOLUTE) {
                return false;
            }
            if (this.USE_RELATIVE_INDENTS != that.USE_RELATIVE_INDENTS) {
                return false;
            }
            if (this.LABEL_INDENT_SIZE != that.LABEL_INDENT_SIZE) {
                return false;
            }
            if (this.SMART_TABS != that.SMART_TABS) {
                return false;
            }
            if (this.TAB_SIZE != that.TAB_SIZE) {
                return false;
            }
            return this.USE_TAB_CHARACTER == that.USE_TAB_CHARACTER;
        }

        public int hashCode() {
            int result = this.INDENT_SIZE;
            result = 31 * result + this.CONTINUATION_INDENT_SIZE;
            result = 31 * result + this.TAB_SIZE;
            result = 31 * result + (this.USE_TAB_CHARACTER ? 1 : 0);
            result = 31 * result + (this.SMART_TABS ? 1 : 0);
            result = 31 * result + this.LABEL_INDENT_SIZE;
            result = 31 * result + (this.LABEL_INDENT_ABSOLUTE ? 1 : 0);
            result = 31 * result + (this.USE_RELATIVE_INDENTS ? 1 : 0);
            return result;
        }

        public void copyFrom(IndentOptions other) {
            CommonCodeStyleSettings.copyPublicFields(other, this);
        }

        FileIndentOptionsProvider getFileIndentOptionsProvider() {
            return this.myFileIndentOptionsProvider;
        }

        void setFileIndentOptionsProvider(FileIndentOptionsProvider provider) {
            this.myFileIndentOptionsProvider = provider;
        }

        void associateWithDocument(Document document) {
            document.putUserData(INDENT_OPTIONS_KEY, this);
        }

        static IndentOptions retrieveFromAssociatedDocument(PsiFile file) {
            Document document = PsiDocumentManager.getInstance(file.getProject()).getDocument(file);
            return document != null ? (IndentOptions)document.getUserData(INDENT_OPTIONS_KEY) : null;
        }
    }

    public static @interface BraceStyleConstant {
    }

    private static class SupportedFieldsDiffFilter
    extends DifferenceFilter<CommonCodeStyleSettings> {
        private final Set<String> mySupportedFieldNames;

        public SupportedFieldsDiffFilter(CommonCodeStyleSettings object, Set<String> supportedFiledNames, CommonCodeStyleSettings parentObject) {
            super((Object)object, (Object)parentObject);
            this.mySupportedFieldNames = supportedFiledNames;
        }

        public boolean isAccept(Field field) {
            if (this.mySupportedFieldNames == null || this.mySupportedFieldNames.contains(field.getName())) {
                return super.isAccept(field);
            }
            return false;
        }
    }
}

