/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementSectionRule;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;

public class ArrangementSectionDetector {
    private final Document myDocument;
    private final ArrangementSettings mySettings;
    private final Consumer<ArrangementSectionEntryTemplate> mySectionEntryProducer;
    private final Stack<ArrangementSectionRule> myOpenedSections = ContainerUtil.newStack();

    public ArrangementSectionDetector(Document document, ArrangementSettings settings, Consumer<ArrangementSectionEntryTemplate> producer) {
        this.myDocument = document;
        this.mySettings = settings;
        this.mySectionEntryProducer = producer;
    }

    public boolean processComment(PsiComment comment) {
        ArrangementSectionRule lastSection;
        TextRange range = comment.getTextRange();
        TextRange expandedRange = this.myDocument == null ? range : ArrangementUtil.expandToLineIfPossible(range, this.myDocument);
        TextRange sectionTextRange = new TextRange(expandedRange.getStartOffset(), expandedRange.getEndOffset());
        String commentText = comment.getText().trim();
        ArrangementSectionRule openSectionRule = ArrangementSectionDetector.isSectionStartComment(this.mySettings, commentText);
        if (openSectionRule != null) {
            this.mySectionEntryProducer.consume((Object)new ArrangementSectionEntryTemplate(comment, StdArrangementTokens.Section.START_SECTION, sectionTextRange, commentText));
            this.myOpenedSections.push((Object)openSectionRule);
            return true;
        }
        if (!this.myOpenedSections.isEmpty() && (lastSection = (ArrangementSectionRule)this.myOpenedSections.peek()).getEndComment() != null && StringUtil.equals((CharSequence)commentText, (CharSequence)lastSection.getEndComment())) {
            this.mySectionEntryProducer.consume((Object)new ArrangementSectionEntryTemplate(comment, StdArrangementTokens.Section.END_SECTION, sectionTextRange, commentText));
            this.myOpenedSections.pop();
            return true;
        }
        return false;
    }

    public static ArrangementSectionRule isSectionStartComment(ArrangementSettings settings, String comment) {
        for (ArrangementSectionRule rule : settings.getSections()) {
            if (rule.getStartComment() == null || !StringUtil.equals((CharSequence)comment, (CharSequence)rule.getStartComment())) continue;
            return rule;
        }
        return null;
    }

    public static class ArrangementSectionEntryTemplate {
        private PsiElement myElement;
        private ArrangementSettingsToken myToken;
        private TextRange myTextRange;
        private String myText;

        public ArrangementSectionEntryTemplate(PsiElement element, ArrangementSettingsToken token, TextRange range, String text) {
            this.myElement = element;
            this.myToken = token;
            this.myTextRange = range;
            this.myText = text;
        }

        public PsiElement getElement() {
            return this.myElement;
        }

        public ArrangementSettingsToken getToken() {
            return this.myToken;
        }

        public TextRange getTextRange() {
            return this.myTextRange;
        }

        public String getText() {
            return this.myText;
        }
    }
}

