/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement.group;

import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;

public class ArrangementGroupingRule {
    private final ArrangementSettingsToken myGroupingType;
    private final ArrangementSettingsToken myOrderType;

    public ArrangementGroupingRule(ArrangementSettingsToken groupingType) {
        this(groupingType, StdArrangementTokens.Order.KEEP);
    }

    public ArrangementGroupingRule(ArrangementSettingsToken groupingType, ArrangementSettingsToken orderType) {
        this.myGroupingType = groupingType;
        this.myOrderType = orderType;
    }

    public ArrangementSettingsToken getGroupingType() {
        return this.myGroupingType;
    }

    public ArrangementSettingsToken getOrderType() {
        return this.myOrderType;
    }

    public ArrangementGroupingRule clone() {
        return new ArrangementGroupingRule(this.myGroupingType, this.myOrderType);
    }

    public int hashCode() {
        int result = this.myGroupingType.hashCode();
        result = 31 * result + this.myOrderType.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrangementGroupingRule rule = (ArrangementGroupingRule)o;
        if (this.myOrderType != rule.myOrderType) {
            return false;
        }
        return this.myGroupingType.equals(rule.myGroupingType);
    }

    public String toString() {
        return String.format("(%s, %s)", this.myGroupingType, this.myOrderType);
    }
}

