/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement.match;

import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.psi.codeStyle.arrangement.ArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.ByModifierArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.ByNameArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.ByNamespaceArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.ByTextArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.ByTypeArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.CompositeArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementAtomMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementCompositeMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchConditionVisitor;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokenType;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StdArrangementEntryMatcher
implements ArrangementEntryMatcher {
    private final ArrangementMatchCondition myCondition;
    private final ArrangementEntryMatcher myDelegate;

    public StdArrangementEntryMatcher(ArrangementMatchCondition condition) {
        this(condition, new StdMatcherBuilderImpl());
    }

    public StdArrangementEntryMatcher(ArrangementMatchCondition condition, StdMatcherBuilder builder) {
        this.myCondition = condition;
        this.myDelegate = StdArrangementEntryMatcher.doBuildMatcher(condition, builder);
    }

    public ArrangementMatchCondition getCondition() {
        return this.myCondition;
    }

    @Override
    public boolean isMatched(ArrangementEntry entry) {
        return this.myDelegate.isMatched(entry);
    }

    public int hashCode() {
        return this.myCondition.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StdArrangementEntryMatcher matcher = (StdArrangementEntryMatcher)o;
        return this.myCondition.equals(matcher.myCondition);
    }

    public String toString() {
        return this.myCondition.toString();
    }

    private static ArrangementEntryMatcher doBuildMatcher(ArrangementMatchCondition condition, StdMatcherBuilder builder) {
        MyVisitor visitor = new MyVisitor(builder);
        condition.invite(visitor);
        return visitor.getMatcher();
    }

    private static class MyVisitor
    implements ArrangementMatchConditionVisitor {
        private final StdMatcherBuilder myMatcherBuilder;
        private boolean nestedComposite;

        private MyVisitor(StdMatcherBuilder matcherBuilder) {
            this.myMatcherBuilder = matcherBuilder;
        }

        @Override
        public void visit(ArrangementAtomMatchCondition condition) {
            this.myMatcherBuilder.onCondition(condition);
        }

        @Override
        public void visit(ArrangementCompositeMatchCondition condition) {
            if (!this.nestedComposite) {
                this.nestedComposite = true;
                for (ArrangementMatchCondition c : condition.getOperands()) {
                    c.invite(this);
                }
            } else {
                this.myMatcherBuilder.addMatcher(StdArrangementEntryMatcher.doBuildMatcher(condition, this.myMatcherBuilder));
            }
        }

        public ArrangementEntryMatcher getMatcher() {
            Collection<ArrangementEntryMatcher> matchers = this.myMatcherBuilder.buildMatchers();
            if (matchers.size() == 1) {
                return matchers.iterator().next();
            }
            CompositeArrangementEntryMatcher result = new CompositeArrangementEntryMatcher(new ArrangementEntryMatcher[0]);
            for (ArrangementEntryMatcher matcher : matchers) {
                result.addMatcher(matcher);
            }
            return result;
        }
    }

    public static class StdMatcherBuilderImpl
    implements StdMatcherBuilder {
        private final List<ArrangementEntryMatcher> myMatchers = ContainerUtilRt.newArrayList();
        protected final MultiValuesMap<StdArrangementTokenType, ArrangementAtomMatchCondition> context = new MultiValuesMap();
        private String myNamePattern;
        private String myNamespacePattern;
        private String myText;

        protected void addToContext(StdArrangementSettingsToken token, ArrangementAtomMatchCondition condition) {
            StdArrangementTokenType tokenType = token.getTokenType();
            this.context.put((Object)tokenType, (Object)condition);
        }

        @Override
        public void onCondition(ArrangementAtomMatchCondition condition) {
            if (StdArrangementTokens.Regexp.NAME.equals(condition.getType())) {
                this.myNamePattern = condition.getValue().toString();
                return;
            }
            if (StdArrangementTokens.Regexp.XML_NAMESPACE.equals(condition.getType())) {
                this.myNamespacePattern = condition.getValue().toString();
            } else if (StdArrangementTokens.Regexp.TEXT.equals(condition.getType())) {
                this.myText = condition.getValue().toString();
            }
            Object v = condition.getValue();
            ArrangementSettingsToken type = condition.getType();
            if (type instanceof StdArrangementSettingsToken) {
                this.addToContext((StdArrangementSettingsToken)type, condition);
            }
        }

        @Override
        public Collection<ArrangementEntryMatcher> buildMatchers() {
            Collection modifierTokens;
            ArrayList result = ContainerUtilRt.newArrayList(this.myMatchers);
            Collection entryTokens = this.context.get((Object)StdArrangementTokenType.ENTRY_TYPE);
            if (entryTokens != null) {
                result.add(new ByTypeArrangementEntryMatcher(entryTokens));
            }
            if ((modifierTokens = this.context.get((Object)StdArrangementTokenType.MODIFIER)) != null) {
                result.add(new ByModifierArrangementEntryMatcher(modifierTokens));
            }
            if (this.myNamePattern != null) {
                result.add(new ByNameArrangementEntryMatcher(this.myNamePattern));
            }
            if (this.myNamespacePattern != null) {
                result.add(new ByNamespaceArrangementEntryMatcher(this.myNamespacePattern));
            }
            if (this.myText != null) {
                result.add(new ByTextArrangementEntryMatcher(this.myText));
            }
            return result;
        }

        @Override
        public void addMatcher(ArrangementEntryMatcher matcher) {
            this.myMatchers.add(matcher);
        }
    }

    public static interface StdMatcherBuilder {
        public void onCondition(ArrangementAtomMatchCondition var1);

        public Collection<ArrangementEntryMatcher> buildMatchers();

        public void addMatcher(ArrangementEntryMatcher var1);
    }
}

