/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.compiled;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiManager;
import com.intellij.psi.compiled.ClsStubBuilder;

public class ClassFileDecompilers {
    public static ExtensionPointName<Decompiler> EP_NAME = ExtensionPointName.create((String)"com.intellij.psi.classFileDecompiler");

    private ClassFileDecompilers() {
    }

    public static Decompiler find(VirtualFile file) {
        for (Decompiler decompiler : (Decompiler[])EP_NAME.getExtensions()) {
            if (!(decompiler instanceof Light) && !(decompiler instanceof Full) || !decompiler.accepts(file)) continue;
            return decompiler;
        }
        return null;
    }

    public static abstract class Full
    implements Decompiler {
        public abstract ClsStubBuilder getStubBuilder();

        public abstract FileViewProvider createFileViewProvider(VirtualFile var1, PsiManager var2, boolean var3);
    }

    public static abstract class Light
    implements Decompiler {
        public abstract CharSequence getText(VirtualFile var1) throws CannotDecompileException;

        public static class CannotDecompileException
        extends RuntimeException {
            public CannotDecompileException(String message) {
                super(message);
            }

            public CannotDecompileException(Throwable cause) {
                super(cause);
            }
        }
    }

    public static interface Decompiler {
        public boolean accepts(VirtualFile var1);
    }
}

