/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.injection;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.util.ui.EmptyIcon;
import javax.swing.Icon;

public abstract class Injectable
implements Comparable<Injectable> {
    public abstract String getId();

    public abstract String getDisplayName();

    public String getAdditionalDescription() {
        return null;
    }

    public Icon getIcon() {
        return EmptyIcon.ICON_16;
    }

    @Override
    public int compareTo(Injectable o) {
        return this.getDisplayName().compareTo(o.getDisplayName());
    }

    public abstract Language getLanguage();

    public Language toLanguage() {
        return this.getLanguage() == null ? new Language(this.getId(), false){

            @Override
            public String getDisplayName() {
                return Injectable.this.getDisplayName();
            }
        } : this.getLanguage();
    }

    public static Injectable fromLanguage(final Language language) {
        return new Injectable(){

            @Override
            public String getId() {
                return language.getID();
            }

            @Override
            public String getDisplayName() {
                return language.getDisplayName();
            }

            @Override
            public String getAdditionalDescription() {
                LanguageFileType ft = language.getAssociatedFileType();
                return ft != null ? " (" + ft.getDescription() + ")" : null;
            }

            @Override
            public Icon getIcon() {
                LanguageFileType ft = language.getAssociatedFileType();
                return ft != null && ft.getIcon() != null ? ft.getIcon() : EmptyIcon.ICON_16;
            }

            @Override
            public Language getLanguage() {
                return language;
            }
        };
    }
}

