/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.ref;

import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiChildLink;
import com.intellij.psi.PsiExpression;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NonNls;

public class AnnotationAttributeChildLink
extends PsiChildLink<PsiAnnotation, PsiAnnotationMemberValue> {
    private final String myAttributeName;

    public AnnotationAttributeChildLink(@NonNls String attributeName) {
        this.myAttributeName = attributeName;
    }

    public String getAttributeName() {
        return this.myAttributeName;
    }

    @Override
    public PsiAnnotationMemberValue findLinkedChild(PsiAnnotation psiAnnotation) {
        if (psiAnnotation == null) {
            return null;
        }
        return psiAnnotation.findDeclaredAttributeValue(this.myAttributeName);
    }

    @Override
    public PsiAnnotationMemberValue createChild(PsiAnnotation psiAnnotation) throws IncorrectOperationException {
        PsiExpression nullValue = JavaPsiFacade.getElementFactory(psiAnnotation.getProject()).createExpressionFromText("null", null);
        psiAnnotation.setDeclaredAttributeValue(this.myAttributeName, nullValue);
        return (PsiAnnotationMemberValue)ObjectUtils.assertNotNull((Object)psiAnnotation.findDeclaredAttributeValue(this.myAttributeName));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnotationAttributeChildLink link = (AnnotationAttributeChildLink)o;
        return this.myAttributeName.equals(link.myAttributeName);
    }

    public int hashCode() {
        return this.myAttributeName.hashCode();
    }
}

