/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class IndexPattern {
    private String myPatternString;
    private Pattern myOptimizedIndexingPattern;
    private boolean myCaseSensitive;
    private Pattern myPattern;

    public IndexPattern(String patternString, boolean caseSensitive) {
        this.myPatternString = patternString;
        this.myCaseSensitive = caseSensitive;
        this.compilePattern();
    }

    public String getPatternString() {
        return this.myPatternString;
    }

    public Pattern getPattern() {
        return this.myPattern;
    }

    public Pattern getOptimizedIndexingPattern() {
        return this.myOptimizedIndexingPattern;
    }

    public boolean isCaseSensitive() {
        return this.myCaseSensitive;
    }

    public void setPatternString(String patternString) {
        this.myPatternString = patternString;
        this.compilePattern();
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.myCaseSensitive = caseSensitive;
        this.compilePattern();
    }

    private void compilePattern() {
        try {
            int flags = 0;
            if (!this.myCaseSensitive) {
                flags = 2;
            }
            this.myPattern = Pattern.compile(this.myPatternString, flags);
            String optimizedPattern = this.myPatternString;
            if (optimizedPattern.startsWith(".*")) {
                optimizedPattern = optimizedPattern.substring(".*".length());
            }
            this.myOptimizedIndexingPattern = Pattern.compile(optimizedPattern, flags);
        }
        catch (PatternSyntaxException e) {
            this.myPattern = null;
            this.myOptimizedIndexingPattern = null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexPattern that = (IndexPattern)o;
        if (this.myCaseSensitive != that.myCaseSensitive) {
            return false;
        }
        return this.myPatternString.equals(that.myPatternString);
    }

    public int hashCode() {
        int result = this.myPatternString.hashCode();
        result = 29 * result + (this.myCaseSensitive ? 1 : 0);
        return result;
    }
}

