/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.LinkedHashSet;

public class LocalSearchScope
extends SearchScope {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.search.LocalSearchScope");
    private final PsiElement[] myScope;
    private final boolean myIgnoreInjectedPsi;
    public static final LocalSearchScope EMPTY = new LocalSearchScope(PsiElement.EMPTY_ARRAY);
    private String myDisplayName;

    public LocalSearchScope(PsiElement scope) {
        this(scope, null);
    }

    public LocalSearchScope(PsiElement scope, String displayName) {
        this(new PsiElement[]{scope});
        this.myDisplayName = displayName;
    }

    public LocalSearchScope(PsiElement[] scope) {
        this(scope, null);
    }

    public LocalSearchScope(PsiElement[] scope, String displayName) {
        this(scope, displayName, false);
    }

    public LocalSearchScope(PsiElement[] scope, String displayName, boolean ignoreInjectedPsi) {
        this.myIgnoreInjectedPsi = ignoreInjectedPsi;
        this.myDisplayName = displayName;
        LinkedHashSet<PsiElement> localScope = new LinkedHashSet<PsiElement>(scope.length);
        for (PsiElement element : scope) {
            LOG.assertTrue(element != null, (Object)"null element");
            LOG.assertTrue(element.getContainingFile() != null, (Object)element.getClass().getName());
            if (element instanceof PsiFile) {
                for (PsiFile file : ((PsiFile)element).getViewProvider().getAllFiles()) {
                    if (file == null) {
                        throw new IllegalArgumentException("file " + element + " returned null in its getAllFiles()");
                    }
                    localScope.add(file);
                }
                continue;
            }
            if (!(element instanceof StubBasedPsiElement) && element.getTextRange() == null) continue;
            localScope.add(element);
        }
        this.myScope = PsiUtilCore.toPsiElementArray(localScope);
    }

    public boolean isIgnoreInjectedPsi() {
        return this.myIgnoreInjectedPsi;
    }

    @Override
    public String getDisplayName() {
        return this.myDisplayName == null ? super.getDisplayName() : this.myDisplayName;
    }

    public PsiElement[] getScope() {
        return this.myScope;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LocalSearchScope)) {
            return false;
        }
        LocalSearchScope localSearchScope = (LocalSearchScope)o;
        if (localSearchScope.myIgnoreInjectedPsi != this.myIgnoreInjectedPsi) {
            return false;
        }
        if (localSearchScope.myScope.length != this.myScope.length) {
            return false;
        }
        for (PsiElement scopeElement : this.myScope) {
            PsiElement[] thatScope;
            for (PsiElement thatScopeElement : thatScope = localSearchScope.myScope) {
                if (Comparing.equal((Object)scopeElement, (Object)thatScopeElement)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = 0;
        result += this.myIgnoreInjectedPsi ? 1 : 0;
        for (PsiElement element : this.myScope) {
            result += element.hashCode();
        }
        return result;
    }

    public LocalSearchScope intersectWith(LocalSearchScope scope2) {
        if (this.equals(scope2)) {
            return this;
        }
        return LocalSearchScope.intersection(this, scope2);
    }

    private static LocalSearchScope intersection(LocalSearchScope scope1, LocalSearchScope scope2) {
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        PsiElement[] elements1 = scope1.myScope;
        PsiElement[] elements2 = scope2.myScope;
        for (PsiElement element1 : elements1) {
            for (PsiElement element2 : elements2) {
                PsiElement element = LocalSearchScope.intersectScopeElements(element1, element2);
                if (element == null) continue;
                result.add(element);
            }
        }
        return new LocalSearchScope(PsiUtilCore.toPsiElementArray(result), null, scope1.myIgnoreInjectedPsi || scope2.myIgnoreInjectedPsi);
    }

    @Override
    public SearchScope intersectWith(SearchScope scope2) {
        if (scope2 instanceof LocalSearchScope) {
            return this.intersectWith((LocalSearchScope)scope2);
        }
        LocalSearchScope nonPhysicalScope = this.tryIntersectNonPhysicalWith((GlobalSearchScope)scope2);
        if (nonPhysicalScope != null) {
            return nonPhysicalScope;
        }
        return ((GlobalSearchScope)scope2).intersectWith(this);
    }

    private LocalSearchScope tryIntersectNonPhysicalWith(GlobalSearchScope scope) {
        Project project = scope.getProject();
        for (PsiElement element : this.myScope) {
            PsiFile containingFile = element.getContainingFile();
            if (containingFile == null) continue;
            if (containingFile.getViewProvider().isPhysical()) {
                return null;
            }
            if (project == null || project == containingFile.getProject()) continue;
            return EMPTY;
        }
        return this;
    }

    private static PsiElement intersectScopeElements(PsiElement element1, PsiElement element2) {
        if (PsiTreeUtil.isContextAncestor(element1, element2, false)) {
            return element2;
        }
        if (PsiTreeUtil.isContextAncestor(element2, element1, false)) {
            return element1;
        }
        if (PsiTreeUtil.isAncestor(element1, element2, false)) {
            return element2;
        }
        if (PsiTreeUtil.isAncestor(element2, element1, false)) {
            return element1;
        }
        return null;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.myScope.length; ++i) {
            PsiElement element = this.myScope[i];
            if (i > 0) {
                result.append(",");
            }
            result.append(((Object)element).toString());
        }
        return "LocalSearchScope:" + result;
    }

    @Override
    public SearchScope union(SearchScope scope) {
        if (scope instanceof LocalSearchScope) {
            return this.union((LocalSearchScope)scope);
        }
        return ((GlobalSearchScope)scope).union(this);
    }

    public SearchScope union(LocalSearchScope scope2) {
        if (this.equals(scope2)) {
            return this;
        }
        PsiElement[] elements1 = this.getScope();
        PsiElement[] elements2 = scope2.getScope();
        boolean[] united = new boolean[elements2.length];
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        block0: for (PsiElement element1 : elements1) {
            for (int j = 0; j < elements2.length; ++j) {
                PsiElement element2 = elements2[j];
                PsiElement unionElement = LocalSearchScope.scopeElementsUnion(element1, element2);
                if (unionElement == null || unionElement.getContainingFile() == null) continue;
                result.add(unionElement);
                united[j] = true;
                break block0;
            }
            result.add(element1);
        }
        for (int i = 0; i < united.length; ++i) {
            boolean b = united[i];
            if (b) continue;
            result.add(elements2[i]);
        }
        return new LocalSearchScope(PsiUtilCore.toPsiElementArray(result));
    }

    private static PsiElement scopeElementsUnion(PsiElement element1, PsiElement element2) {
        if (PsiTreeUtil.isAncestor(element1, element2, false)) {
            return element1;
        }
        if (PsiTreeUtil.isAncestor(element2, element1, false)) {
            return element2;
        }
        PsiElement commonParent = PsiTreeUtil.findCommonParent(element1, element2);
        if (commonParent == null) {
            return null;
        }
        return commonParent;
    }

    public boolean isInScope(VirtualFile file) {
        for (PsiElement element : this.myScope) {
            PsiFile containingFile = element.getContainingFile();
            if (containingFile == null || !Comparing.equal((Object)containingFile.getVirtualFile(), (Object)file)) continue;
            return true;
        }
        return false;
    }

    public boolean containsRange(PsiFile file, TextRange range) {
        for (PsiElement element : this.getScope()) {
            if (file != element.getContainingFile() || !element.getTextRange().contains(range)) continue;
            return true;
        }
        return false;
    }
}

