/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.PackageIndex;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;

public class PackageScope
extends GlobalSearchScope {
    private final Collection<VirtualFile> myDirs;
    private final PsiPackage myPackage;
    private final boolean myIncludeSubpackages;
    private final boolean myIncludeLibraries;
    protected final boolean myPartOfPackagePrefix;
    protected final String myPackageQualifiedName;
    protected final String myPackageQNamePrefix;

    public PackageScope(PsiPackage aPackage, boolean includeSubpackages, boolean includeLibraries) {
        super(aPackage.getProject());
        this.myPackage = aPackage;
        this.myIncludeSubpackages = includeSubpackages;
        Project project = this.myPackage.getProject();
        this.myPackageQualifiedName = this.myPackage.getQualifiedName();
        this.myDirs = PackageIndex.getInstance(project).getDirsByPackageName(this.myPackageQualifiedName, true).findAll();
        this.myIncludeLibraries = includeLibraries;
        this.myPartOfPackagePrefix = JavaPsiFacade.getInstance(this.getProject()).isPartOfPackagePrefix(this.myPackageQualifiedName);
        this.myPackageQNamePrefix = this.myPackageQualifiedName + ".";
    }

    @Override
    public boolean contains(VirtualFile file) {
        String packageName;
        PsiFile psiFile;
        for (VirtualFile scopeDir : this.myDirs) {
            boolean inDir = this.myIncludeSubpackages ? VfsUtilCore.isAncestor(scopeDir, file, false) : Comparing.equal((Object)file.getParent(), (Object)scopeDir);
            if (!inDir) continue;
            return true;
        }
        return this.myPartOfPackagePrefix && this.myIncludeSubpackages && (psiFile = this.myPackage.getManager().findFile(file)) instanceof PsiClassOwner && (this.myPackageQualifiedName.equals(packageName = ((PsiClassOwner)psiFile).getPackageName()) || packageName.startsWith(this.myPackageQNamePrefix));
    }

    @Override
    public int compare(VirtualFile file1, VirtualFile file2) {
        return 0;
    }

    @Override
    public boolean isSearchInModuleContent(Module aModule) {
        return true;
    }

    @Override
    public boolean isSearchInLibraries() {
        return this.myIncludeLibraries;
    }

    public String toString() {
        return "package scope: " + this.myPackage + ", includeSubpackages = " + this.myIncludeSubpackages;
    }

    public static GlobalSearchScope packageScope(PsiPackage aPackage, boolean includeSubpackages) {
        return new PackageScope(aPackage, includeSubpackages, true);
    }

    public static GlobalSearchScope packageScopeWithoutLibraries(PsiPackage aPackage, boolean includeSubpackages) {
        return new PackageScope(aPackage, includeSubpackages, false);
    }
}

