/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.concurrency.AsyncFuture;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiNonJavaFileReferenceProcessor;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.util.Processor;

public interface PsiSearchHelper {
    public PsiElement[] findCommentsContainingIdentifier(String var1, SearchScope var2);

    public boolean processCommentsContainingIdentifier(String var1, SearchScope var2, Processor<PsiElement> var3);

    public PsiFile[] findFilesWithPlainTextWords(String var1);

    public boolean processUsagesInNonJavaFiles(String var1, PsiNonJavaFileReferenceProcessor var2, GlobalSearchScope var3);

    public boolean processUsagesInNonJavaFiles(PsiElement var1, String var2, PsiNonJavaFileReferenceProcessor var3, GlobalSearchScope var4);

    public SearchScope getUseScope(PsiElement var1);

    public boolean processAllFilesWithWord(String var1, GlobalSearchScope var2, Processor<PsiFile> var3, boolean var4);

    public boolean processAllFilesWithWordInText(String var1, GlobalSearchScope var2, Processor<PsiFile> var3, boolean var4);

    public boolean processAllFilesWithWordInComments(String var1, GlobalSearchScope var2, Processor<PsiFile> var3);

    public boolean processAllFilesWithWordInLiterals(String var1, GlobalSearchScope var2, Processor<PsiFile> var3);

    public boolean processRequests(SearchRequestCollector var1, Processor<PsiReference> var2);

    public AsyncFuture<Boolean> processRequestsAsync(SearchRequestCollector var1, Processor<PsiReference> var2);

    public boolean processElementsWithWord(TextOccurenceProcessor var1, SearchScope var2, String var3, short var4, boolean var5);

    public boolean processElementsWithWord(TextOccurenceProcessor var1, SearchScope var2, String var3, short var4, boolean var5, boolean var6);

    public AsyncFuture<Boolean> processElementsWithWordAsync(TextOccurenceProcessor var1, SearchScope var2, String var3, short var4, boolean var5);

    public SearchCostResult isCheapEnoughToSearch(String var1, GlobalSearchScope var2, PsiFile var3, ProgressIndicator var4);

    public static enum SearchCostResult {
        ZERO_OCCURRENCES,
        FEW_OCCURRENCES,
        TOO_MANY_OCCURRENCES;

    }

    public static class SERVICE {
        private SERVICE() {
        }

        public static PsiSearchHelper getInstance(Project project) {
            return ServiceManager.getService(project, PsiSearchHelper.class);
        }
    }
}

